"""This script is used to generate ScintillaConstants.py from
scintilla.iface."""

import sys
import os

header = """# The file was automatically generated by %s
# from %s
#
# Do not manually edit!

"""

lexer_header = """# LexerModule ids (used in find_lexer_module_by_id)

"""

state_header = """
# Lexical states (style constants returned by tokenize_by_style)

"""
    
def find_scintilla_constants(f):
    lexers = []
    states = []
    
    for name in f.order:
        v = f.features[name]
        if v['Category'] != 'Deprecated':
            if v['FeatureType'] == 'val':
                if name.startswith('SCE_'):
                    states.append((name, v["Value"]))
                elif name.startswith('SCLEX_'):
                    lexers.append((name, v["Value"]))

    return (lexers, states)
    
def write_scintilla_constants(out, lexers, states):
    out.write(lexer_header)
    for name, value in lexers:        
        out.write(name + " = " + value + "\n")

    last_prefix = ''
    out.write(state_header)
    for name, value in states:
        prefix = name.split('_')[1]
        if prefix != last_prefix:
            out.write("\n")
            last_prefix = prefix
        out.write(name + " = " + value + "\n")

def create_constants_file(iface_file, out_file):
    import Face

    face = Face.Face()
    face.ReadFromFile(iface_file)

    out = open(out_file, 'w')
    out.write(header % (os.path.basename(sys.argv[0]), os.path.basename(iface_file)))
    lexers, states = find_scintilla_constants(face)
    write_scintilla_constants(out, lexers, states)
    
if __name__ == "__main__":
    if len(sys.argv) != 4:
        print "usage: write_scintilla.py <path to Face.py> <scintilla.iface> <output file>"
        sys.exit(1)

    face_path = sys.argv[1]
    sys.path.append(face_path)

    create_constants_file(sys.argv[2], sys.argv[3])
