declaration = r'''
IDENT               := NONDIGIT, ( DIGIT / NONDIGIT )*, whsp*
NONDIGIT            := [a-zA-Z]
NONDIGIT2           := [a-ru-zA-RU-Z]
DIGIT               := [0-9]

whsp                := [ \t\r\n]
alphanums           := [a-zA-Z0-9]+
start               := whsp*, stored_definition*

stored_definition   := class_definition, ";", whsp*
class_definition    := "model ", IDENT, element_list*, "end", whsp+, IDENT
#stored_definition   := "model ", IDENT, element_list*, "end", whsp+, IDENT, ";", whsp*

elements            := element_list*

element_list        := name, NONDIGIT*, ";", whsp*
name                := alphanums, whsp*
'''

print '---------------START-------------'
testString = '''
model Test
 Real x;
end Test;
'''

from simpleparse import generator
from mx import TextTools
import pprint

parser = generator.buildParser( declaration ).parserbyname('elements' )
shortText = """Real x;
end Test;"""
success, tags, next = TextTools.tag( shortText, parser )
TextTools.print_tags( shortText, tags)
