"""
If you change NONDIGIT_STRANGE from [a-zA-SU-Z]+ to [a-zA-Z]+ the parsing fails.
It is unclear why the letter "T" causes the parsing process to fail.

"""
declaration = r'''# note use of raw string when embedding in python code...
IDENT               := NONDIGIT, ( DIGIT / NONDIGIT )*

DIGIT               := [0-9]+
NONDIGIT_STRANGE    := [a-zA-SU-Z]+
NONDIGIT            := [_a-zA-Z.]+
STRING              := "'", ( S_CHAR / S_ESCAPE / whsp)*, "'"
S_CHAR              := (alphanums / safepunct / wordpunct / '*')+
S_ESCAPE            := ("\\" /"\a" / "\b" / "\f" / "\n" / "\r" / "\t")

stored_definition   := whsp*,(("within", whsp+), name?, whsp*, ";", whsp*)?,(("final", whsp+)?, class_definition, whsp*,";", whsp*)*
name                := alphanums, ('.', alphanums)*
class_definition    := ("encapsulated", whsp+)?, ("partial", whsp+)?, (("class"/"model"/"record"/"block"/"connector"/"type"/"package"/"function"), whsp+), IDENT, whsp+, class_specifier
class_specifier     := string_comment, composition, ("end", whsp+), IDENT

string_comment      := (STRING, ( "+", STRING )*, whsp+ )?
composition         := element_list, ( (("public", whsp+), element_list) / (("protected", whsp+), element_list) )*
element_list        := ( (element,  whsp*, ";", whsp*) / (annotation, whsp*, ";", whsp*) )*
element             := import_clause / extends_clause / ( ("final", whsp+)?, (("inner", whsp+) / ("outer", whsp+))?, (class_definition / component_clause ) )
import_clause       := ("import", whsp+), ( (IDENT, whsp*, "=", whsp*, name) / (name, [*.]) )
extends_clause      := ("extends", whsp+), name, class_modification?
class_modification  := ""

IDENT2              :=  NONDIGIT_STRANGE, (DIGIT / NONDIGIT_STRANGE)*
component_clause    := type_prefix, type_specifier, IDENT2
type_prefix         := ("fl", whsp+)?, ( ("disc", whsp+) / ("par", whsp+) / ("const", whsp+) )?, ( ("in", whsp+) / ("out", whsp+) )?
type_specifier      := name, whsp+


comment        := string_comment, annotation?
annotation     := ("annotation", whsp+), class_modification

whitespace     := whsp
whsp           := [ \t\r\n]+
alphanums      := [a-zA-Z0-9]+


wordpunct      := [-_]
safepunct      := [^!@#$%&()+=|\{}:;<>,.?`/"]
'''

print '---------------START-------------'
testString = '''
model Test
  extends DL.MD;
  M.Bl.So.Step Aa22Aa;
end Test;
'''


from simpleparse import generator
from mx import TextTools
import pprint


parser = generator.buildParser( declaration ).parserbyname('stored_definition' )
pprint.pprint( TextTools.tag( testString, parser ))
