"""
If you change NONDIGIT_STRANGE from [a-zA-SU-Z]+ to [a-zA-Z]+ the parsing fails.
It is unclear why the letter "T" causes the parsing process to fail.

"""
declaration = r'''# note use of raw string when embedding in python code...

DIGIT               := [0-9]+
NONDIGIT_STRANGE    := [a-zA-SU-Z]+
NONDIGIT            := [_a-zA-Z.]+
STRING              := "'", ( S_CHAR / S_ESCAPE / whsp)*, "'"
S_CHAR              := (alphanums / safepunct / wordpunct / '*')+
S_ESCAPE            := ("\\" /"\a" / "\b" / "\f" / "\n" / "\r" / "\t")

stored_definition   := whsp*,(("within", whsp+), name?, whsp*, ";", whsp*)?,(("final", whsp+)?, class_definition, whsp*,";", whsp*)*
name                := alphanums, ('.', alphanums)*
class_definition    := ("encapsulated", whsp+)?, ("partial", whsp+)?, (("class"/"model"/"record"/"block"/"connector"/"type"/"package"/"function"), whsp+), IDENT, whsp+, class_specifier
class_specifier     := string_comment,!, composition, ("end", whsp+), IDENT

string_comment      := (STRING, ( "+", STRING )*, whsp+ )?
composition         := element_list, ( (("public", whsp+), element_list) / (("protected", whsp+), element_list) )*
element_list        := ( (element,  !, whsp*, ";", whsp*) / (annotation, !, whsp*, ";", whsp*) )*
element             := ?-"end", (import_clause / extends_clause / ( ("final", whsp+)?, (("inner", whsp+) / ("outer", whsp+))?, (class_definition / component_clause ) ))
import_clause       := ("import", whsp+), ( (IDENT, whsp*, "=", whsp*, name) / (name, [*.]) )
extends_clause      := ("extends", whsp+), name, class_modification?
class_modification  := ""

IDENT               :=  NONDIGIT, ( DIGIT / NONDIGIT )*
#IDENT2              :=  NONDIGIT_STRANGE, (DIGIT / NONDIGIT_STRANGE)*
component_clause    := type_prefix, type_specifier, IDENT
#component_clause2    := type_prefix, type_specifier, IDENT2
type_prefix         := ("fl", whsp+)?, ( ("disc", whsp+) / ("par", whsp+) / ("const", whsp+) )?, ( ("in", whsp+) / ("out", whsp+) )?
type_specifier      := name, whsp+


comment        := string_comment, annotation?
annotation     := ("annotation", whsp+), class_modification

whitespace     := whsp
whsp           := [ \t\r\n]+
alphanums      := [a-zA-Z0-9]+


wordpunct      := [-_]
safepunct      := [^!@#$%&()+=|\{}:;<>,.?`/"]
'''

print '---------------START-------------'
testString = '''
model Test
  extends DL.MD;
  M.Bl.So.Step Aa22Aa;
end Test;
'''


from simpleparse.parser import Parser
from mx import TextTools
import pprint



parser = Parser( declaration, 'stored_definition' )
####parser = generator.buildParser( declaration ).parserbyname('component_clause' )
###pprint.pprint( TextTools.tag( testString[31:50], parser ))
result = parser.parse( testString )
TextTools.print_tags( testString, result[1] )

		
if __name__ == "__main__":
	import unittest

	class NDStrangeTests( unittest.TestCase ):
		def test_IDENT( self ):
			text = 'Aa22Aa'
			success, tags, next = Parser( declaration, 'IDENT' ).parse( text )
			assert next == len(text), """Didn't parse the whole IDENT with the IDENT2 tag: %s"""%(tags,)
			text = 'Aa22AaT'
			success, tags, next = Parser( declaration, 'IDENT' ).parse( text )
			assert next == 7, """Didn't parse the whole IDENT with the IDENT2 tag: %s"""%(tags,)
			text = 'Aa22AaT;\nT'
			success, tags, next = Parser( declaration, 'IDENT' ).parse( text )
			assert next == 7, """Didn't parse the whole IDENT with the IDENT2 tag: %s"""%(tags,)
			text = 'Aa22Aa;\nend Test'
			success, tags, next = Parser( declaration, 'IDENT' ).parse( text )
			assert next == 6, """Didn't parse the whole IDENT with the IDENT2 tag: %s"""%(tags,)
			
		def test_component_clause( self ):
			text = 'M.Bl.So.Step Aa22Aa'
			success, tags, next = Parser( declaration, 'component_clause' ).parse( text )
			assert next == len(text), """Didn't parse the whole component_clause with the component_clause tag: %s"""%(tags,)
		def test_component_clause( self ):
			text = 'M.Bl.So.Step Aa22Aa'
			success, tags, next = Parser( declaration, 'element' ).parse( text )
			assert next == len(text), """Didn't parse the whole text with the element tag: %s"""%(tags,)

		def test_element_list( self ):
			text = "extends DL.MD;\n  M.Bl.So.Step Aa22Aa;\n"
			success, tags, next = Parser( declaration, 'element_list' ).parse( text )
			assert next == len(text), """Didn't parse the whole text with the element_list tag: %s"""%(tags,)
			#TextTools.print_tags( text, tags )
		def test_composition( self ):
			text = "extends DL.MD;\n  M.Bl.So.Step Aa22Aa;\n"
			success, tags, next = Parser( declaration, 'composition' ).parse( text )
			assert next == len(text), """Didn't parse the whole text with the composition tag: %s"""%(tags,)
			#TextTools.print_tags( text, tags )
		def test_class_specifier( self ):
			text = "extends DL.MD;\n  M.Bl.So.Step Aa22Aa;\n"
			success, tags, next = Parser( declaration, 'composition' ).parse( text )
			TextTools.print_tags( text, tags )
			assert next == len(text), """Didn't parse the whole text with the class_specifier tag: %s"""%(tags,)
			
			
			
	unittest.main()
	