<?
/**********************************************
* ϸ: plugin.pre.BearTemplateSyntax.php
*   : BearTemplate Syntax Converter for SkyTemplate
*   : v1.1.0
* ۼ: ϴþƺ (daddy@withsky.net)
***********************************************/

    function BearTemplateSyntax(&$compiler, $var, $global="")
    {
        $src = &$compiler->Src[$var];

        $from = array(
			"/\{\{([a-z0-9_-]+)\}\}/i",
            "/<!-- (INCLUDE|REQUIRE) FILE '([^']+)' -->/e",
            "/<!-- EXECUTE FILE '([a-zA-Z0-9_-]+)' -->/e",
            "/<!-- DYNAMIC AREA '([a-zA-Z0-9_-]+)' -->/e",
        );

        $to = array(
			$compiler->dlm[0]."\\1".$compiler->dlm[1],
            "BearTemplateSyntaxInclude('\\2', array('".$compiler->dlm[0]."','".$compiler->dlm[1]."'));",
            "BearTemplateSyntaxExecute('\\2', array('".$compiler->dlm[0]."','".$compiler->dlm[1]."'));",
            "BearTemplateSyntaxDynamicArea('$var', '\\1', array('".$compiler->dlm[0]."','".$compiler->dlm[1]."'));",
        );

        // ۷ι 
        if ($global) {
            $from[] = "/([\{]{1,2})(".$global.")([\}]{1,2})/";
            $to[] = "\\1.\\2\\3";
        }
        $src = preg_replace($from, $to, $src);
	}

    // callback
    function BearTemplateSyntaxInclude($file, $dlm)
    {
        $file = preg_replace("/\{\{([a-zA-Z0-9_.-]+)\}\}/", "{\\1}", $file);
        return $dlm[0]."INCLUDE \"$file\"".$dlm[1]; // "{#$file}"
    }

    function BearTemplateSyntaxExecute($file, $dlm)
    {
        $file = preg_replace("/\{\{([a-zA-Z0-9_.-]+)\}\}/", "{\\1}", $file);
        return $dlm[0]."EXECUTE \"$file\"".$dlm[1]; // "{+$file}"
    }

    function BearTemplateSyntaxDynamicArea($var, $name, $dlm)
    {
        static $arr = array();

        if (!isset($arr[$var][$name])) {
            $arr[$var][$name] = true;
            return $dlm[0]."LOOP $name".$dlm[1]; // "{@$name}"
        } else {
            return $dlm[0]."END".$dlm[1]; // "{/}"
        }
    }
?>