#!/usr/bin/perl

# smae_in_otherrun.pl, distributed as part of Snortsnarf v021111.1
# Author: James Hoagland, Silicon Defense (hoagland@SiliconDefense.com)
# copyright (c) 2000 by Silicon Defense (http://www.silicondefense.com/)
# Released under GNU General Public License, see the COPYING file included
# with the distribution or http://www.silicondefense.com/software/snortsnarf/
# for details.

# same_in_otherrun.pl is a CGI script to scan the directories produced in
# other SnortSnarf runs for a corresponding page to a given page.  These 
# directories are looked for in the given base directory.  Corresponding has
# different meaning for different page types:
# + signature index page: sig index page in other runs
# + signaure page:  sig page whose name has the same root (up to a '-')
# + ip page:  same IP address involved whether standard or anom, source or dest; links to overview page only

# Please send complaints, kudos, and especially improvements and bugfixes to
# hoagland@SiliconDefense.com.  As described in GNU General Public License, no
# warranty is expressed for this program.

use CGI;

# get parameters of the invocation
$input= new CGI;
foreach (@ARGV) {  # simulate field input if running on command line
  $input->param(split('=',$_,2));
}
$basedir= $input->param('basedir');
$baseurl= $input->param('baseurl');
$pagetype= $input->param('pagetype');
$pageinfo= $input->param('pageinfo');
$dirsep= $input->param('dirsep');

# print out headers
print $input->header(-header => 'text/html',-expires => '+0d');

@pages= ();
opendir(BASE,$basedir) || die "could not open base directory $basedir";
while ($root= readdir(BASE)) {
    $path= "$basedir$dirsep$root";
    next unless -d $path;
    if ($pagetype eq 'sigindex') {
        push(@pages,&dig_for_page_in_dir($path,"index."));
    } elsif ($pagetype eq 'anomstart') {
        push(@pages,&dig_for_page_in_dir("$path$dirsep".'anomrep',"index."));
    } elsif ($pagetype eq 'sig') {
        $pageinfo =~ /^([^-]+)/;
        push(@pages,&dig_for_page_in_dir("$path$dirsep".'sig',$1));
    } elsif ($pagetype eq 'ip') {
        $pageinfo =~ /^(src|dest)(\d+)\.(\d+)\.(\d+)\.(\d+)/;
        $pagedir= "$2$dirsep$3$dirsep$4";
        $ip= "$1.$2.$3.$4";
        push(@pages,&dig_for_page_in_dir("$path$dirsep$pagedir", "src$ip."));
        push(@pages,&dig_for_page_in_dir("$path$dirsep$pagedir", "dest$ip."));
        push(@pages,&dig_for_page_in_dir("$path$dirsep"."anomrep/$pagedir", "src$ip."));
        push(@pages,&dig_for_page_in_dir("$path$dirsep"."anomrep$pagedir", "dest$ip."));
    } else {
        die "unknown page type: $pagetype";
    }
}

print <<">>";
<HTML>
<HEAD>
<TITLE>Corresponding $pagetype pages in $basedir</TITLE>
</HEAD>
<BODY bgcolor="#E7DEBD">
<H1>Corresponding $pagetype pages in $basedir</H1>
>>

if (@pages==0) {
    print "No corresponding pages were found.\n";
} else {
    print +@pages." found:<UL>\n";
    foreach $page (reverse sort @pages) {
        $page =~ s/^$basedir//;
        print "<LI><A HREF=\"$baseurl/$page\">$page</A>\n";
    }
    print "</UL>\n";
}
print <<">>";
<P>
Use your browser's back command to return to the previous page.
<P>
Generated by $0 from <$basedir,$pagetype,$pageinfo,$baseurl,$dirsep>
</BODY>
</HTML>
>>

sub dig_for_page_in_dir {
    my($dir,$filestart)= @_;
    my $file;
    my @ret= ();
    unless (opendir(D,$dir)) {
        warn "could not open directory $dir; skipping";
        return ();
    }
    $filestart =~ s/([\.\+\(\)\[\]\*\\)/\\$1/g;
    while ($file= readdir(D)) {
        push(@ret,$file) if $file =~ /^$filestart/;
    }
    return @ret;
}

1;

# $Id$
