
/*
	TEDDY - General graphics application library
	Copyright (C) 1999-2002  Timo Suoranta
	tksuoran@cc.helsinki.fi

	This library is free software; you can redistribute it and/or
	modify it under the terms of the GNU Lesser General Public
	License as published by the Free Software Foundation; either
	version 2.1 of the License, or (at your option) any later version.

	This library is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	Lesser General Public License for more details.

	You should have received a copy of the GNU Lesser General Public
	License along with this library; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

	$Id: FrontierBitmap.cpp,v 1.2 2002/01/14 09:14:55 tksuoran Exp $
*/


#include "Teddy/SysSupport/Types.h"
#include "Teddy/SysSupport/StdIO.h"
#include "Teddy/SysSupport/StdString.h"

#include "FrontierBitmap.h"
#include "FrontierFile.h"


static Uint8 ffe_palette[128*3] = {
	0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x08, 0x08, 0x08,
	0x0c, 0x0c, 0x0c, 0x10, 0x10, 0x10, 0x14, 0x14, 0x14,
	0x18, 0x18, 0x18, 0x1c, 0x1c, 0x1c, 0x20, 0x20, 0x20,
	0x24, 0x24, 0x24, 0x28, 0x28, 0x28, 0x2c, 0x2c, 0x2c,
	0x30, 0x30, 0x30, 0x34, 0x34, 0x34, 0x38, 0x38, 0x38,
	0x3c, 0x3c, 0x3c, 0x3c, 0x00, 0x00, 0x00, 0x3c, 0x00,
	0x3c, 0x3c, 0x00, 0x04, 0x08, 0x04, 0x0a, 0x02, 0x06,
	0x12, 0x04, 0x06, 0x0a, 0x0a, 0x08, 0x1a, 0x02, 0x02,
	0x0a, 0x0a, 0x10, 0x12, 0x0a, 0x0a, 0x22, 0x02, 0x02,
	0x04, 0x08, 0x1c, 0x0c, 0x12, 0x10, 0x2a, 0x02, 0x02,
	0x1a, 0x0a, 0x0c, 0x22, 0x0a, 0x0a, 0x32, 0x02, 0x02,
	0x0e, 0x1a, 0x10, 0x0c, 0x20, 0x0c, 0x06, 0x0a, 0x2a,
	0x14, 0x12, 0x14, 0x2a, 0x0a, 0x08, 0x08, 0x2c, 0x08,
	0x0c, 0x26, 0x0c, 0x1a, 0x12, 0x14, 0x08, 0x30, 0x08,
	0x3a, 0x04, 0x04, 0x14, 0x1a, 0x14, 0x22, 0x12, 0x0e,
	0x0e, 0x2c, 0x0a, 0x32, 0x0a, 0x08, 0x12, 0x20, 0x14,
	0x12, 0x26, 0x0e, 0x18, 0x20, 0x10, 0x2a, 0x12, 0x0e,
	0x18, 0x26, 0x0c, 0x1a, 0x1a, 0x16, 0x22, 0x14, 0x16,
	0x22, 0x1a, 0x10, 0x3a, 0x0a, 0x08, 0x1e, 0x20, 0x0e,
	0x34, 0x12, 0x06, 0x18, 0x20, 0x16, 0x2a, 0x1a, 0x0c,
	0x32, 0x1a, 0x04, 0x1e, 0x26, 0x0e, 0x12, 0x16, 0x2a,
	0x14, 0x26, 0x18, 0x2a, 0x14, 0x14, 0x10, 0x32, 0x10,
	0x24, 0x22, 0x0e, 0x0c, 0x12, 0x36, 0x3c, 0x12, 0x08,
	0x32, 0x12, 0x12, 0x22, 0x1a, 0x1a, 0x18, 0x26, 0x18,
	0x1e, 0x20, 0x18, 0x16, 0x2e, 0x14, 0x2a, 0x22, 0x0e,
	0x1a, 0x1a, 0x26, 0x34, 0x20, 0x08, 0x16, 0x22, 0x24,
	0x3c, 0x1a, 0x06, 0x10, 0x14, 0x38, 0x2a, 0x1a, 0x18,
	0x1e, 0x26, 0x1a, 0x24, 0x22, 0x18, 0x3a, 0x12, 0x12,
	0x14, 0x34, 0x16, 0x30, 0x20, 0x10, 0x32, 0x1a, 0x16,
	0x32, 0x2a, 0x06, 0x3c, 0x22, 0x04, 0x1e, 0x2e, 0x18,
	0x2a, 0x22, 0x18, 0x1e, 0x20, 0x26, 0x12, 0x1a, 0x3a,
	0x34, 0x32, 0x02, 0x1a, 0x36, 0x18, 0x3c, 0x2a, 0x04,
	0x2a, 0x2a, 0x16, 0x1e, 0x26, 0x26, 0x1a, 0x1a, 0x38,
	0x3a, 0x1a, 0x18, 0x24, 0x2c, 0x1c, 0x24, 0x22, 0x26,
	0x1e, 0x30, 0x20, 0x32, 0x26, 0x16, 0x32, 0x32, 0x0c,
	0x2a, 0x22, 0x24, 0x24, 0x2a, 0x26, 0x3c, 0x34, 0x04,
	0x30, 0x22, 0x22, 0x1e, 0x24, 0x36, 0x24, 0x32, 0x22,
	0x2a, 0x2a, 0x26, 0x3c, 0x3a, 0x04, 0x24, 0x24, 0x32,
	0x24, 0x28, 0x30, 0x3a, 0x22, 0x22, 0x2a, 0x30, 0x28,
	0x24, 0x24, 0x3c, 0x24, 0x28, 0x3a, 0x32, 0x2a, 0x2c,
	0x2a, 0x2a, 0x36, 0x3a, 0x2a, 0x28, 0x2c, 0x30, 0x30,
	0x32, 0x32, 0x2e, 0x2c, 0x30, 0x3c, 0x32, 0x32, 0x38,
	0x3a, 0x32, 0x32, 0x38, 0x3a, 0x38
};


FrontierBitmap::FrontierBitmap( FrontierFile *f, char *label ){
	this->f = f;

	int     x, y;
	int     i, w, h, sw;
	Uint32  zero;
	Uint16  head[27];       // Complete header size
	FILE   *out_file;


	f->reset();
	f->seek( label );
	char *tmp = f->get_label_def();

	Uint8   flags  = f->read_Uint8();
	Uint8   height = f->read_Uint8();
	Uint16  width  = f->read_Uint16();
	Sint16  xoff   = f->read_Sint16();
	Sint16  yoff   = f->read_Sint16();

	int  ret = 0;
	char tmps [200];
	char fname[200];
	strcpy( tmps, label );
	int ll = strlen( tmps );
	tmps[ll-1] = 0;
	sprintf( fname, "ffe_%s.bmp", tmps );

/*	
	cout << "Frontier Bitmap " << fname << endl;
	cout << "Flags:  " << (int)(flags)  << endl;
	cout << "Height: " << (int)(height) << endl;
	cout << "Width:  " << (int)(width)  << endl;
	cout << "XOff:   " << (int)(xoff)   << endl;
	cout << "YOff:   " << (int)(yoff)   << endl;*/

	for( i=0; i<27; i++ ){
		head[i] = 0;        // Zero whole header
	}
	w    = width;
	h    = height;
	sw   = w + 3 & -4;
	zero = 0;

	out_file = fopen( fname, "wb" );
	if( out_file == NULL ){
		printf( "could not open out file %s\n", fname );
		return;
	}

	head[0]  = 0x4D42;       // RgbMap type 'BM'
	*(Uint32*)(head+1) = 54 + 256*4 + sw*h;  // Total filesize
	head[5]  = 54 + 256*4;   // Offset to data
	head[7]  = 40;           // Size of info structure
	head[9]  = sw;           // Width
	head[11] = height;       // Height
	head[13] = 1;            // Planes
	head[14] = 8;            // Bpp

	ret = fwrite( head, 2, 27, out_file );   // Write header
	if( ret!=27 ){
		printf( "write fails, ret = %d\n", ret );
	}
	for( i=0; i<128; i++ ){
		Uint32 col =
			(Uint32(ffe_palette[i*3  ]) << 18) +
			(Uint32(ffe_palette[i*3+1]) << 10) +
			(Uint32(ffe_palette[i*3+2]) <<  2);
		ret = fwrite( &col, 4, 1, out_file );  // Write Palette
		if( ret!=1 ){
			printf( "write fails, ret = %d\n", ret );
		}
	}
	for( i=0; i<128; i++ ){
		ret = fwrite( &zero, 4, 1, out_file );
		if( ret!=1 ){
			printf( "write fails, ret = %d\n", ret );
		}
	}

	//  Read in down top order
	Uint8 t[320*256];
	for( i=0; i<w*h; i++ ){
		t[i] = 0;
	}

	for( y=h-1; y>=0; y-- ){
		for( x=0; x<w; x++ ){
			t[x+y*sw] = f->get_byte();
		}
	}

	//  Write in top down order
	for( y=0; y<h; y++ ){
		for( x=0; x<sw; x++ ){
			fwrite( &t[x+y*sw], 1, 1, out_file );  // Write data
			if( ret!=1 ){
				printf( "write fails, ret = %d\n", ret );
			}
		}
	}

	ret = fflush( out_file );
	if( ret!=0 ){
		printf( "fflush fails\n" );
	}
	ret = fclose( out_file );
	if( ret!=0 ){
		printf( "fclose fails\n" );
	}
//	cout << "file written and closed" << endl;
}


