
/*
	TEDDY - General graphics application library
	Copyright (C) 1999-2002  Timo Suoranta
	tksuoran@cc.helsinki.fi

	This library is free software; you can redistribute it and/or
	modify it under the terms of the GNU Lesser General Public
	License as published by the Free Software Foundation; either
	version 2.1 of the License, or (at your option) any later version.

	This library is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	Lesser General Public License for more details.

	You should have received a copy of the GNU Lesser General Public
	License along with this library; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

	$Id: LWSceneEffects.cpp,v 1.1 2002/02/16 12:41:39 tksuoran Exp $
*/


#include "Teddy/TeddyConfig.h"
#if defined( TEDDY_INCLUDE_LW_SCENE )


#include "Teddy/Imports/LWSceneFile.h"
#include "Teddy/Imports/LWSceneParser.h"
using namespace Teddy::Graphics;


namespace Teddy   {
namespace Imports {


/*
	BGImage < image path + filename> [(sequence)]
	FGImage <image path + filename> [(sequence)]
	FGAlphaImage < image path + filename> [(sequence)]

	example:  BGImage Images/Sky.tga
	example:  BGImage Images/BldColor.tga

	example:  FGAlphaImage Images/BldAlpha.tga

	The BGImage, FGImage and FGAlphaImage functions provides
	the path and filename for the background, foreground and
	foreground alpha channel images respectively. The paths
	are generated by checking the current content directory
	for the listed filenames.  

	In these examples if the current content directory is
	<c:\NewTek>, LightWave would attempt to load the files
	<c:\NewTek\Images\Sky.tga>, <c:\NewTek\Images\BldColor.tga>
	and <c:\NewTek\Images\BldAlpha.tga>.

	It is possible to use image sequences for these functions.
	If an image sequence is chosen, a sequence identifier is
	appended to the image path and filename. An additional
	ImageSequenceInfo listing is also produced. (See Image
	Sequences Section 1.5)
*/
void LWSceneParser::BGImage(){
	char *bg_image = file->read_string();
}


void LWSceneParser::FGImage(){
	char *fg_image = file->read_string();
}


void LWSceneParser::FGAlphaImage(){
	char *fg_alpha_image = file->read_string();
}


/*
	FGDissolve <percentage>  (envelope)

	example:  FGDissolve 0.750000

	The FGDissolve function provides the dissolve
	percentage of the foreground image. This function
	is most widely used with an envelope to produce a
	smooth fade from a foreground image to the current
	scene.
*/
void LWSceneParser::FGDissolve(){
	double fg_dissolve = file->read_double();
}


/*
	FGFaderAlphaMode <flag>

	example:  FGFaderAlphaMode 1

	The FGFaderAlphaMode flag activates the foreground
	fader alpha mode. This modes provides an additional
	type of Alpha channel image compositing.

	<flag>:
		0 - Off (No Listing)
		1 - On (Listing)
*/
void LWSceneParser::FGFaderAlphaMode(){
	int fg_fader_alpha_mode = file->read_int();
}


/*
	Additional: ImageSequenceInfo <frame offset> <loop flag> <loop length>

	The ImageSequenceInfo listing is produced only when
	an image sequence is chosen. It provides optional
	information for the image sequence. (See Image
	Sequences Section 1.5)
*/
void LWSceneParser::ImageSequenceInfo(){
	int frame_offset = file->read_int();
	int loop_flag    = file->read_int();
	int loop_length  = file->read_int();
}


/*
	ForegroundKey <flag>

	example:  ForegroundKey 1

	The ForegroundKey flag activates the foreground keying
	function in the image composting process of LightWave.
	This function allows the user to set a HighClipColor
	and a LowClipColor for the clipping of the foreground 
	image.

	<flag>:
		0 - Off (No Listing)
		1 - On (Listing plus additional listings)
*/
void LWSceneParser::ForegroundKey(){
	int foreground_key = file->read_int();
}

/*
	Additional:  LowClipColor <Red value> <Green value> <Blue value>

	Additional:  HighClipColor <Red value> <Green value> <Blue value>

	example:  LowClipColor 0 0 0

	example:  HighClipColor 125 125 125

	The LowClipColor and HighClipColor functions provides
	the "darkest" and the "brightest" RGB color respectively
	for the ForegroundKey function.
*/
void LWSceneParser::LowClipColor(){
	double red   = file->read_double();
	double green = file->read_double();
	double blue  = file->read_double();
}
void LWSceneParser::HighClipColor(){
	double red   = file->read_double();
	double green = file->read_double();
	double blue  = file->read_double();
}


/*
	BackdropColor <Red value> <Green value> <Blue value>

	example:  BackdropColor 125 125 125

	The BackdropColor function provides the RGB values
	for the backdrop color. These values are used only
	when the SolidBackdrop flag is turned on.
*/
void LWSceneParser::BackdropColor(){
	double red   = file->read_double();
	double green = file->read_double();
	double blue  = file->read_double();
}


/*
	SolidBackdrop <flag>

	example:  SolidBackdrop 1

	The SolidBackdrop flag activates a single color
	backdrop. If the flag is turned off, a gradient
	backdrop is produced using the RGB color values 
	provided in the Backdrop Color, Zenith Color,
	Sky Color, and Nadir Color listings.

	<flag>:
		0 - Off (Gradient Backdrop)
		1 - On (SolidBackdrop)
*/
void LWSceneParser::SolidBackdrop(){
	int solid_backdrop = file->read_int();
}


/*
	The ZenithColor, SkyColor, GroundColor, and Nadir
	Color functions provide the RBG values for the
	gradient backdrop. These values are used only when
	the SolidBackdrop flag is turned off.
*/
void LWSceneParser::ZenithColor(){
	double red   = file->read_double();
	double green = file->read_double();
	double blue  = file->read_double();
	zenith_color = Color( red, green, blue );
}
Color LWSceneParser::getZenithColor(){
	return zenith_color;
}
void LWSceneParser::SkyColor(){
	double red   = file->read_double();
	double green = file->read_double();
	double blue  = file->read_double();
	sky_color = Color( red, green, blue );
}
Color LWSceneParser::getSkyColor(){
	return sky_color;
}
void LWSceneParser::GroundColor(){
	double red   = file->read_double();
	double green = file->read_double();
	double blue  = file->read_double();
	ground_color = Color( red, green, blue );
}
Color LWSceneParser::getGroundColor(){
	return ground_color;
}
void LWSceneParser::NadirColor(){
	double red   = file->read_double();
	double green = file->read_double();
	double blue  = file->read_double();
	nadir_color  = Color( red, green, blue );
}
Color LWSceneParser::getNadirColor(){
	return nadir_color;
}

void LWSceneParser::SkySqueezeAmount(){}
void LWSceneParser::GroundSqueezeAmount(){}


/*
	FogType <value>

	example:  FogType 1

	The FogType function determines which type of fog
	will be generated during the rendering process. If
	the Fog effect is turned on in LightWave,
	additional listings are produced.

	<value>:
		0 - Off
		1 - Linear
		2 - NonLinear 1
		3 - NonLinear 2
*/
void LWSceneParser::FogType(){
	int fog_type = file->read_int();
}


/*
	Additional:  FogMinDist <Distance>  (envelope)

	example:  FogMinDist 25.000000

	The FogMinDist function provides the distance from
	the camera that the fog will begin. This functions
	value can be fluctuated over time with an envelope.
	If an envelope is chosen, the distance value is
	replace with an envelope identifier.
*/
void LWSceneParser::FogMinDist(){
	double fog_min_dist = file->read_double();
}


/*
	Additional:  FogMaxDist <Distance>  (envelope)

	example:  FogMaxDist 350.00000

	The Fog MaxDist function provides the distance from
	camera that objects in the fog will remain visible.
	This functions value can be fluctuated over time with
	an envelope. If an envelope is chosen, the distance
	value is replace with an envelope identifier.
*/
void LWSceneParser::FogMaxDist(){
	double fog_max_dist = file->read_double();
}


/*
	Additional:  FogMinAmount <percentage>  (envelope)

	example:  FogMinAmount 0.250000

	The FogMinAmount function provides the lower bounding
	value for the density (amount) of fog in the scene.
*/
void LWSceneParser::FogMinAmount(){
	double fog_min_amount = file->read_double();
}


/*
	Additional:  FogMaxAmount <percentage>  (envelope)

	example:  FogMaxAmount 0.750000

	The FogMaxAmount function provides the upper bounding
	value for the density (amount) of fog in the scene.
*/
void LWSceneParser::FogMaxAmount(){
	double fog_max_amount = file->read_double();
}


/*
	Additional:  FogColor <Red value> <Green value> <Blue value>

	example:  FogColor 200 200 215

	The FogColor function provides the RGB values for the
	color of the fog. These values are used only when the
	BackdropFog flag is turned off.
*/
void LWSceneParser::FogColor(){
	double red   = file->read_double();
	double green = file->read_double();
	double blue  = file->read_double();
}


/*
	Additional:  BackdropFog <flag>

	example:  BackdropFog 1

	The BackdropFog flag determines how the fog will
	be colored. If the flag is on, the fog will use
	the backdrop color. If the flag is off, it will
	use the values provided in the 	FogColor function.

	<flag>:
		0 - Use FogColor
		1 - Use Backdrop Colors
*/
void LWSceneParser::BackdropFog(){
	int backdrop_fog = file->read_int();
}


/*
	DitherIntensity <value>

	example:  DitherIntensity 2

	The DitherIntensity function provides the type of
	dithering to be used during the rendering process.

	<value>:
		0 - Off
		1 - Normal
		2 - 2 x Normal
		3 - 4 x Normal
*/
void LWSceneParser::DitherIntensity(){
	int dither_intensity = file->read_int();
}


/*
	AnimatedDither <flag>

	example:  AnimatedDither 1

	The AnimatedDither flag activates the animated dither function.
	This will use an alternate dithering pattern frame by frame.

	<flag>:
		0 - Off
		1 - On 
*/
void LWSceneParser::AnimatedDither(){
	int animated_dither = file->read_int();
}


/*
	Saturation <percentage>  (envelope)

	example:  Saturation 0.350000

	The Saturation function provides the percentage of
	color saturation to be used during the rendering
	process. The function produces a listing only 
	when set below 100%.
*/
void LWSceneParser::Saturation(){
	double saturation = file->read_double();
}


/*
	GlowEffect <flag>

	example:  GlowEffect 1

	The GlowEffect flag activates the glow effect for
	the rendering process. When this function is turned
	on, it allows any surface that has it's glow effect
	flag turned on to be affected by the glow post-process.
	This function, when turned on, produces a listing plus
	additional option listings.

	<flag>:
		0 - Off (No Listing)
		1 - On (Listing plus additional listings)
*/
void LWSceneParser::GlowEffect(){
	int glow_effect = file->read_int();
}


/*
	Additional:  GlowIntensity <percentage>  (envelope)

	example:  GlowIntensity 1.000000

	The GlowIntensity provides the percentage of glow intensity 
	(brightness) that the glow post-process will produce.
*/
void LWSceneParser::GlowIntensity(){
	double glow_intensity = file->read_double();
}


/*
	Additional:  GlowRadius <pixels>  (envelope)

	example:  GlowRadius 8.000000

	The GlowRadius provides the glow distance, in pixels,
	that the glow post-process will produce.
*/
void LWSceneParser::GlowRadius(){
	double glow_radius = file->read_double();
}


};  //  namespace Imports
};  //  namespace Teddy


#endif  //  TEDDY_INCLUDE_LW_SCENE


/*

The Effects section contains the information that relates
to the different effects that are available in a LightWave
scene.

The following is a list of Effects functions that are
listed in the order in which they appear in the scene file.

		BGImage
		FGImage
		FGAlphaImage
		FGDissolve
		FGFaderAlphaMode
		ForegroundKey
			LowClipColor
			HighClipColor
		SolidBackdrop *
		BackdropColor *
		ZenithColor *
		SkyColor *
		GroundColor *
		NadirColor *
		FogType *
			FogMinDist
			FogMaxDist
			FogMinAmount
			FogMaxAmount
			FogColor
			BackdropFog
		DitherIntensity *
		AnimatedDither *
		Saturation
		GlowEffect
			GlowIntensity
			GlowRadius
		DataOverlay
		DataOverlayLabel *
*/

