/*
** Jabby (a C library for Jabber protocol)
** Copyright (c) 2002 Hubert Sokoowski <who_ami@tlen.pl>
**
** This code is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License.
**
*/


#include "jabby.h"
#include "search.h"

#include <string.h>

GList *events_list;

jabby_event *jabby_event_new(enum jabby_event_type type)
{
  jabby_event *event;

  event = g_malloc(sizeof(*event));
  memset(event, 0, sizeof(*event));
  event->type = type;
  switch(type)
  {
    case JABBY_EVENT_ERROR:
      break;
    case JABBY_EVENT_MESSAGE:
      break;
    case JABBY_EVENT_SUBSCRIBE:
      break;
    case JABBY_EVENT_SUBSCRIBED:
      break;
    case JABBY_EVENT_UNSUBSCRIBE:
      break;
    case JABBY_EVENT_UNSUBSCRIBED:
      break;
    case JABBY_EVENT_ROSTER_ITEM:
//      event->event.roster->jid = g_strdup();
      break;
    case JABBY_EVENT_ROSTER_END:
      break;
    case JABBY_EVENT_PRESENCE:
      break;
    case JABBY_EVENT_UNAUTHORIZED:
      break;
    case JABBY_EVENT_CONNECTION_FAILED:
      break;
    case JABBY_EVENT_SEARCH_ITEM:
      break;
    case JABBY_EVENT_SEARCH_END:
      break;
    case JABBY_EVENT_AGENT:
      break;
    case JABBY_EVENT_AGENTS_END:
      break;
    case JABBY_EVENT_REGISTERED:
      break;
    default:
      g_print("Unknown event type passed to jabby_event_new !\n");
      g_free(event);
      return NULL;
  }
  return event;
}

jabby_event_registered* jabby_event_registered_new()
{
  jabby_event_registered *reg;

  reg = g_malloc(sizeof(*reg));
  memset(reg, 0, sizeof(*reg));
  return reg;
}

jabby_event_agent* jabby_event_agent_new()
{
  jabby_event_agent *agent;

  agent = g_malloc(sizeof(*agent));
  memset(agent, 0, sizeof(*agent));
  return agent;
}

void jabby_event_free(jabby_event *event)
{
  switch(event->type)
  {
    case JABBY_EVENT_ROSTER_ITEM:
      g_free(event->event.roster->jid);
      g_free(event->event.roster->name);
      g_free(event->event.roster->group);
      g_free(event->event.roster->subscription);
      g_free(event->event.roster);
      break;
    case JABBY_EVENT_ERROR:
      g_free(event->event.error->message);
      break;
    case JABBY_EVENT_MESSAGE:
      g_free(event->event.message->from);
      g_free(event->event.message->id);
      g_free(event->event.message->body);
      g_free(event->event.message->subject);
      g_free(event->event.message->thread);
      g_free(event->event.message->error);
      g_free(event->event.message->delay);
      break;
    case JABBY_EVENT_PRESENCE:
      g_free(event->event.presence->from);
      g_free(event->event.presence->message);
      break;
    case JABBY_EVENT_SUBSCRIBE:
      g_free(event->event.subscribe->from);
      g_free(event->event.subscribe->status);
      break;
    case JABBY_EVENT_SUBSCRIBED:
      g_free(event->event.subscribed->from);
      break;
    case JABBY_EVENT_UNSUBSCRIBE:
      g_free(event->event.unsubscribe->from);
      g_free(event->event.unsubscribe->status);
      break;
    case JABBY_EVENT_UNSUBSCRIBED:
      g_free(event->event.unsubscribed->from);
      g_free(event->event.unsubscribed->status);
      break;
    case JABBY_EVENT_SEARCH_ITEM:
       jabby_search_res_free(event->event.search);
      break;
    case JABBY_EVENT_AGENT:
      g_free(event->event.agent->jid);
      g_free(event->event.agent->name);
      g_free(event->event.agent->service);
      g_free(event->event.agent->transport);
      g_free(event->event.agent);
      break;
    case JABBY_EVENT_REGISTERED:
      g_free(event->event.registered->to);
      g_free(event->event.registered);
      break;
    default:
      break;
  }
  g_free(event);
}

void jabby_event_add(jabby_event *event)
{
  events_list = g_list_append(events_list, event);
}

jabby_event *jabby_event_get()
{
  jabby_event *event = NULL;
  GList *first;

  first = g_list_first(events_list);
  if(first)
  {
    event = (jabby_event*) first->data;
    events_list = g_list_remove(events_list, first->data);
  }
  return event;
}

