/*
** TleenX2 (Tlen.pl Client)
** Copyright (c) 2002-2003 Hubert Sokoowski <who_ami@tlen.pl>
**                         Pawe Biliski <rael@fr.pl>
**
** Thanks to GG2 Team for most of this code
**
** This code is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License.
**
*/


#ifndef DISABLE_DOCKLET

#include "main.h"
#include <X11/Xatom.h>

#include "eggtrayicon.h"
#include "utils.h"
#include "support.h"

static GtkWidget *pixmap = NULL;
static GtkTooltips *tooltips = NULL;
static GtkWidget *docklet = NULL;

void docklet_change_status(guint status)
{
  gchar *s=NULL;
  /* set status icon */
  gtk_image_set_from_pixbuf(GTK_IMAGE(pixmap),
                            gtk_image_get_pixbuf(GTK_IMAGE(icons[status])));
  gtk_widget_show(pixmap);
  /* set tooltip */
  s = utf(g_strdup_printf("TleenX2 : %s",opisy[status-2]));
  gtk_tooltips_set_tip(tooltips,docklet,s,NULL);
  g_free(s);
}

static
void docklet_clicked_cb(GtkWidget * widget, GdkEventButton * ev, gpointer data)
{
  GtkWidget *menu;
  
  if(!window1) return;

  if(ev->button == 3) {
    menu = lookup_widget(window1, "menu_tlen");
    gtk_menu_popup(GTK_MENU(menu), NULL, NULL, NULL, NULL,
        ev->button, ev->time);
  }
  else if(ev->button == 2) {
    menu = lookup_widget(window1, "menu_status");
    gtk_menu_popup(GTK_MENU(menu), NULL, NULL, NULL, NULL,
        ev->button, ev->time);
  }
  else if(ev->button == 1) {
    if(GTK_WIDGET_VISIBLE(window1)) {
      gtk_window_get_position(GTK_WINDOW(window1), &posx, &posy);
      gtk_widget_hide(window1);
    }
    else {
      gtk_window_move(GTK_WINDOW(window1), posx, posy);
      gtk_widget_show(window1);
    }
  }

}

void create_docklet()
{
  GtkWidget *eventbox;
  GdkAtom kwm_dockwindow_atom = gdk_atom_intern("KWM_DOCKWINDOW", FALSE);
  GdkAtom kde_net_system_tray_window_for_atom =
          gdk_atom_intern("_KDE_NET_WM_SYSTEM_TRAY_WINDOW_FOR", FALSE);
  glong data[1];
  EggTrayIcon *egg = egg_tray_icon_new("TleenX 2");

  if (!egg) return;

  if (egg->manager_window == None) {
    docklet = gtk_window_new(GTK_WINDOW_TOPLEVEL);
    gtk_window_set_title(GTK_WINDOW(docklet), "TleenX2_docklet");
    gtk_window_set_wmclass(GTK_WINDOW(docklet),
                           "GM_Statusdocklet", "tleenx2-dock");
    gtk_window_set_decorated(GTK_WINDOW(docklet), 0);
    gtk_window_set_type_hint (GTK_WINDOW(docklet), GDK_WINDOW_TYPE_HINT_DOCK);

    gtk_widget_set_usize(GTK_WIDGET(docklet), 22, 22);
  }  else {
    docklet = GTK_WIDGET(egg);
  }

  gtk_widget_realize(GTK_WIDGET(docklet));

  /* kde 1 & gnome 1.2 */
  data[0] = TRUE;
  gdk_property_change( docklet->window,
                       kwm_dockwindow_atom,
                       kwm_dockwindow_atom,
                       32,
                       GDK_PROP_MODE_REPLACE,
                       (guchar *)&data,
                       1 );

  /* kde 2 */
  data[0] = 0;
  gdk_property_change( docklet->window,
                       kde_net_system_tray_window_for_atom,
                       (GdkAtom)XA_WINDOW,
                       32,
                       GDK_PROP_MODE_REPLACE,
                       (guchar *)&data,
                       1 );


  /* tooltip */
  tooltips = gtk_tooltips_new();
  gtk_tooltips_enable(tooltips);
  
  pixmap = gtk_image_new();

  eventbox = gtk_event_box_new();

  gtk_container_add(GTK_CONTAINER(eventbox), pixmap);
  gtk_container_add(GTK_CONTAINER(docklet), eventbox);

  g_signal_connect(G_OBJECT(docklet),"button_press_event",
                   G_CALLBACK(docklet_clicked_cb),pixmap);

  gtk_widget_show_all(docklet);

  status_docklet = docklet;
  //docklet_change_status(TLEN_STATUS_UNAVAILABLE);
  if(window1) docklet_change_status(status);
  else docklet_change_status(TLEN_STATUS_UNAVAILABLE);

}



#endif

