/*
** TleenX2 (Tlen.pl Client)
** Copyright (c) 2002-2003 Hubert Sokoowski <who_ami@tlen.pl>
**                         Pawe Biliski <rael@fr.pl>
**
** This code is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License.
**
*/

#include "main.h"
#include "jabby.h"
#include "utils.h"
#include "conffile.h"
#include "lista.h"
#include "users.h"
#include "chat.h"
#include "messages.h"
#include "jabber.h"
#include "windows.h"
#include "xmms-info.h"

static jabby_session *ses;
static gint jtimerid;

static gboolean gg_present;

void jabber_presence(gint type, gchar *message, gchar *to)
{
  jabby_presence(ses, type, message, to);
}

void jabber_agent(gchar *jid, gchar *message)
{
  jabber_message(jid, message, JABBY_MESSAGE_CHAT);
}

void jabber_gg_agent(gchar *message)
{
  jabber_message(profile->ggserver, message, JABBY_MESSAGE_CHAT);
}

void jabber_gg_message(gchar *to, gchar *message)
{
  gchar *jid;

  if(!strchr(to, '@'))
    jid = g_strdup_printf("%s@%s", to, profile->ggserver);
  else
    jid = g_strdup(to);
  jabber_message(jid, message, JABBY_MESSAGE_CHAT);
  g_free(jid);
}

void jabber_register_gg()
{
  jabby_register_to(ses, profile->ggserver, profile->ggnumber,
                    profile->ggpassword);
}

void jabber_register_sms()
{
  jabby_register_to(ses, profile->sms, profile->smsid,
                    profile->smspassword);
}

void jabber_unregister_gg()
{
  jabby_register_to(ses, profile->ggserver, "","");
}

gboolean jabber_registered_to_sms()
{
  gchar *jid;
  struct user *u;

  jid = g_strdup_printf("%s/registered", profile->sms);
  u = get_user(jid);
  g_free(jid);
  if(!u)
    return FALSE;
  if(strcmp(u->subscription, "both"))
    return FALSE;
  return TRUE;
}

gboolean jabber_registered_to_gg()
{
  gchar *jid;
  struct user *u;

  jid = g_strdup_printf("%s/registered", profile->ggserver);
  u = get_user(jid);
  g_free(jid);
  if(!u)
    return FALSE;
  if(strcmp(u->subscription, "both"))
    return FALSE;
  return TRUE;
}

//gboolean jabber_gg_set()
//{
//  if(strlen(profile->ggnumber) && strlen(profile->ggpassword))
//    return TRUE;
//  return FALSE;
//}

void jabber_get_agents()
{
  gg_present = FALSE;
  jabby_get_agents(ses);
}

void jabber_subscribe_accept(gchar *jid)
{
  jabby_subscribe_accept(ses, jid);
}

void jabber_subscribe_deny(gchar *jid)
{
  jabby_subscribe_deny(ses, jid);
}

void jabber_subscribe_ask(gchar *jid)
{
  jabby_subscribe_ask(ses, jid, NULL);
}

void jabber_message(gchar *to, gchar *message, gint type)
{
  gchar *s = utf(message);

  jabby_message(ses, to, NULL, s, NULL, type);
  g_free(s);
}

void jabber_contact_delete(struct user *user)
{
  jabby_contact_remove(ses, user->jid);
  if(subscription_to(user))
    jabby_unsubscribe(ses, user->jid);
  if(subscription_from(user))
    jabby_subscribe_deny(ses, user->jid);
}

void jabber_contact_add(gchar *name, gchar *jid, gchar *group)
{
  jabby_contact_add(ses, name, jid, group);
}

gboolean jabber_logged()
{
  if(ses)
    if(ses->state == JABBY_NET_ON)
      return TRUE;
  return FALSE;
}

gboolean jabber_created()
{
  return ses ? TRUE : FALSE;
}

void jabber_new()
{
  gchar *id;

  id = "asd";
  id = g_strdup_printf("%s@%s/%s", profile->jlogin, profile->jserver,
                       profile->jresource);
  ses = jabby_session_new(id, profile->jpassword);
  g_free(id);
}

static gint jabber_timer(gpointer g)
{
  jabby_event *event;
  struct user *user;
  gchar *ask, *name, *group;
  gint type;

  event = jabby_event_next(ses);
  if(!event)
    return TRUE;

  switch(event->type)
  {
    case JABBY_EVENT_UNAUTHORIZED:
      info("Bd podczas logowania do serwera Jabber.");
      jabby_disconnect(ses);
      jabby_session_free(ses);
      ses = NULL;
      return FALSE;
      break;
    case JABBY_EVENT_CONNECTION_FAILED:
      info("Nie mona poczy si z serwerem Jabbera");
      jabby_disconnect(ses);
      jabby_session_free(ses);
      status_jabber_button_set(JABBY_PRESENCE_UNAVAILABLE);
      status_gg_button_set(JABBY_PRESENCE_UNAVAILABLE);
      ses = NULL;
      return FALSE;
      break;
    case JABBY_EVENT_ROSTER_ITEM:
      ask = event->event.roster->ask;
      name = event->event.roster->name;
      group = event->event.roster->group;
      type = get_type(event->event.roster->jid);
      g_print("got user %s ask: %s group: %s\n",event->event.roster->jid,
               event->event.roster->ask, group );
//      if(type == USER_AGENT)
//        break;
      name = fromutf(name);
      group = fromutf(group);
      if(!get_user(event->event.roster->jid))
        add_user(name?name:"",
                 event->event.roster->jid,
                 group?group:"",
                 event->event.roster->subscription,
                 "",
                 ask?ask:"",
                 JABBY_PRESENCE_UNAVAILABLE + 2, type);
      g_free(name);
      g_free(group);
      break;
    case JABBY_EVENT_ROSTER_END:
      jabby_presence(ses, t_status_map[status], "", NULL);
      status_jabber_button_set(t_status_map[status]);
      refresh_gui();
//      xmms_info_check();
      if(profile->ggnumber && profile->ggpassword)
        jabber_get_agents();
      break;
    case JABBY_EVENT_MESSAGE:
      {
        gint type;

        type = event->event.message->type;
        g_print("message from %s: %s\n",event->event.message->from,
                event->event.message->body);
        message_show(
                     event->event.message->from,
                     event->event.message->body,
                     event->event.message->delay,
                     (type==JABBY_MESSAGE_NORMAL)?TLEN_MESSAGE:TLEN_CHAT);
      }
      break;
    case JABBY_EVENT_PRESENCE:
      g_print("presence from %s with type %d and message %s\n",
              event->event.presence->from,
              event->event.presence->type,
              event->event.presence->message);
      if(profile->ggserver)
      if(!strcmp(profile->ggserver, event->event.presence->from))
      {
//        if(event->event.presence->type == JABBY_PRESENCE_UNAVAILABLE)
//        {
//          info("Zerwano poczenie z serwerem Gadu-Gadu");
//        }
        status_gg_button_set(event->event.presence->type);
        break;
      }
//      if(get_type(event->event.presence->from) == USER_AGENT)
//        break;
      user = get_user(event->event.presence->from);
      if(user)
      {
        gchar *message;
        gint type;

        message = event->event.presence->message;
        type = get_type(event->event.presence->from);
        add_user(NULL,
                 event->event.presence->from,
                 NULL,
                 NULL,
                 message?message:"",
                 NULL,
                 event->event.presence->type + 2, type);
        window_talk_update_on_presence(user->jid);
        refresh_gui_on_presence(user);
      }
      break;
    case JABBY_EVENT_SUBSCRIBE:
      {
        struct user *u=get_user(event->event.subscribe->from);
        gint type;

        type = get_type(event->event.subscribe->from);
        if(!u)
        {
          g_print("no such user\n");
          jabby_subscribe_accept(ses, event->event.subscribe->from);
          jabby_contact_add(ses,"", event->event.subscribe->from, "");
          add_user("",event->event.subscribe->from,"","from","","",
                   JABBY_PRESENCE_UNAVAILABLE+2, type);
        }
        else
        {
          if(!strcmp(u->subscription,"none"))
          {
            jabby_subscribe_accept(ses, event->event.subscribe->from);
            add_user(NULL, event->event.subscribe->from,NULL,"from","",NULL,
                     JABBY_PRESENCE_UNAVAILABLE+2, -1);
          }
          else
            add_user(NULL, event->event.subscribe->from,NULL,"both",NULL,NULL,
                     -1, -1);
        }
        if(preferences & PREF_BEEPONA)
          play_sound(SOUNDA);
        my_create_window_authorize(event->event.subscribe->from);
        break;
      }
    case JABBY_EVENT_SUBSCRIBED:
      {
        struct user *user;

        user = get_user(event->event.subscribed->from);
        if(user)
        {
          if(!strcmp(user->subscription, "from"))
            add_user(NULL,event->event.subscribed->from,NULL,"both",NULL,"",-1,
                     -1);
          else
            add_user(NULL,event->event.subscribed->from,NULL,"to",NULL,"",-1,
                     -1);
          refresh_gui();
        }
        break;
      }
    case JABBY_EVENT_UNSUBSCRIBE:
      {
//        jabby_tlen_accept_unsubscribe(ses,event->event.unsubscribe->from);
        if(get_user(event->event.unsubscribe->from))
        {
          add_user(NULL,event->event.unsubscribe->from,"","none","","",
                   JABBY_PRESENCE_UNAVAILABLE+2, -1);
          refresh_gui();
          jabby_unsubscribe(ses,event->event.unsubscribe->from);
        }
        break;
      }
//      jabby_unsubscribe(ses, event->event.unsubscribe->from);
    case JABBY_EVENT_UNSUBSCRIBED:
      add_user(NULL,event->event.unsubscribed->from,"","none","","",
               JABBY_PRESENCE_UNAVAILABLE+2, -1);
      refresh_gui();
//      jabby_contact_remove(ses, event->event.unsubscribed->from);
      break;
    case JABBY_EVENT_AGENT:
      if(!strcmp(event->event.agent->service, "x-gadugadu"))
      {
        if(!gg_present)
        {
          gg_present = TRUE;
          profile->ggserver = g_strdup(event->event.agent->jid);
          status_gg_button_set(JABBY_PRESENCE_AVAILABLE);
        }
      }
      if(!strcmp(event->event.agent->service, "sms"))
      {
//        sms_present = TRUE;
        profile->sms = g_strdup(event->event.agent->jid);
//        status_gg_button_set(JABBY_PRESENCE_AVAILABLE);
      }
      break;
    case JABBY_EVENT_AGENTS_END:
      if(gg_present != FALSE)
      {
        refresh_gui();
//        info("gg ok");
//        if(jabber_registered_to_gg() == FALSE)
//          jabber_register_gg();
//        if(jabber_registered_to_gg())
//        {
//          jabber_unregister_gg();
//        }
//        jabber_register_gg();
      }
      break;
    case JABBY_EVENT_SEARCH_ITEM:
    case JABBY_EVENT_SEARCH_END:
    case JABBY_EVENT_REGISTERED:
      break;
    case JABBY_EVENT_ERROR:
      if(preferences & PREF_DEBUGON)
      {
        g_print("jabber: error event\n");
      }
      break;
    case JABBY_EVENT_UNKNOWN:
      if(preferences & PREF_DEBUGON)
        g_print("jabber: unknown event\n");
      break;
    default:
      break;
  }
  jabby_event_free(event);
  return TRUE;
}

static gpointer jabber_connect(gpointer g)
{
  jabby_connect(ses);
  jtimerid = gtk_timeout_add (100, jabber_timer , NULL);
  return NULL;
}

void jabber_login()
{
  GError *er;

  g_thread_create(jabber_connect, NULL, FALSE, &er);
}

void jabber_logout()
{
  jabby_disconnect(ses);
}

void jabber_free()
{
  jabby_session_free(ses);
  ses = NULL;
}

