/*
** TleenX2 (Tlen.pl Client)
** Copyright (c) 2002-2003 Hubert Sokoowski <who_ami@tlen.pl>
**                         Pawe Biliski <rael@fr.pl>
**
** This code is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License.
**
*/

#include "main.h"
#include "windows.h"
#include "utils.h"
#include "chat.h"
#include "lista.h"
#ifndef DISABLE_DOCKLET
#include "docklet.h"
#endif
#include "jabber.h"
#include "conffile.h"

void on_menu_user_clipboard (struct user *user)
{
  GtkClipboard *defaultClip;
  gchar *desc;

  if (!user)
    return;
  desc = user->description;
  defaultClip = gtk_clipboard_get (GDK_SELECTION_PRIMARY);
  if (desc)
  {
    printf ("dodaje %s\n", desc);
    gtk_clipboard_set_text (defaultClip, desc, strlen (desc));
  }
}

void on_menu_user_mesg(const gchar *jid)
{
  message_send((gchar*)jid, NULL);
}

void on_menu_user_check(const gchar *jid)
{
  if(!window_search)
    my_create_window_search();
  window_search_check((gchar *) jid);
}

void on_menu_user_edit(struct user *user)
{
  contact_add(user->jid, user->type);
}

void on_menu_user_delete(struct user *user)
{
  switch(user->type)
  {
    case USER_TLEN:
      tlen_removecontact(session,user->jid);
      if(!strcmp(user->subscription, "to"))
        tlen_request_unsubscribe(session, user->jid);
      break;
    case USER_JABBER:
    case USER_WP:
    case USER_GG:
    case USER_AGENT:
      jabber_contact_delete(user);
      break;
  }
  del_user(user->jid);
  refresh_gui();
}

void on_menu_user_chat(struct user *user)
{
  struct talk *talk;

  if((talk = get_talk(user->jid)))
  {
    gtk_window_deiconify(GTK_WINDOW(talk->window));
    return;
  }
  my_create_window_chat(user->jid);
  talk=get_talk(user->jid);
  chat_set_title(talk, 0);
}


void menu_status_response(gchar *s)
{
  gint status2=0;

  if(!strcmp(s,"1"))
  {
    status2=TLEN_STATUS_AVAILABLE;
    autoaway = TRUE;
  }
  if(!strcmp(s,"2"))
  {
    status2=TLEN_STATUS_CHATTY;
    autoaway = FALSE;
  }
  if(!strcmp(s,"3"))
  {
    status2=TLEN_STATUS_DND;
    autoaway = FALSE;
  }
  if(!strcmp(s,"4"))
  {
    status2=TLEN_STATUS_AWAY;
    autoaway = FALSE;
  }
  if(!strcmp(s,"5"))
  {
    status2=TLEN_STATUS_EXT_AWAY;
    autoaway = FALSE;
  }
  if(!strcmp(s,"6"))
  {
    status2=TLEN_STATUS_INVISIBLE;
    autoaway = FALSE;
  }
  if(!strcmp(s,"7"))
  {
    if(cant_stop)
      return;
    work_offline();
    return;
  }
  if(!strcmp(s,"8"))
  {
    my_create_window_desc();
    return;
  }
  if(status2 == status)
    return;
  status=status2;
  set_status(status);
}

gint menu_show(GtkWidget *menu, GdkEvent *event)
{
  if (event->type == GDK_BUTTON_PRESS)
  {
    GdkEventButton *bevent = (GdkEventButton *) event;

    gtk_menu_popup (GTK_MENU (menu), NULL, NULL, NULL, NULL,
                    bevent->button, bevent->time);
    return TRUE;
  }
  return FALSE;
}

void menu_tlen_show()
{
}

void menu_status_show()
{
}

void
on_wyszukiwanie1_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  if(!online)
  {
    info("Musisz by poczony z serwerem.");
    return;
  }
  if(!window_search)
    my_create_window_search();

}

void
on_wyslij_wiadomosc_activate              (GtkMenuItem     *menuitem,
                                           gpointer         user_data)
{
  message_send(NULL, NULL);
}

void
on_wyslij_sms_activate              (GtkMenuItem     *menuitem,
                                     gpointer         user_data)
{
  if(!jabber_logged())
  {
    info("Brak poczenia z jabberem.");
    return;
  }
  if(!jabber_registered_to_sms())
  {
    info("Musisz si najpierw zarejestrowa, sprawd ustawienia SMS.");
    return;
  }
  my_create_window_sms();
}

void
on_wizytowka_activate              (GtkMenuItem     *menuitem,
                                    gpointer         user_data)
{
  my_create_window_card();
}

void
on_kontakty_activate              (GtkMenuItem     *menuitem,
                                   gpointer         user_data)
{
  my_create_window_contacts();
}


void
on_dodaj_kontakt1_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

  if(!online)
  {
    info("Musisz by poczony z serwerem.");
    return;
  }
  contact_add(NULL, USER_TLEN);
}


void
on_archiwum1_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  if(!window_archive)
    my_create_window_archive();

}


void
on_ustawienia_gg_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  if(!jabber_logged())
  {
    info("Brak poczenia z serwerem jabbera.");
    return;
  }
  if(!window_gg)
    my_create_window_gg();

}


#ifndef DISABLE_DOCKLET
void on_menu_show_docklet_activate(GtkMenuItem *menuitem, gpointer user_data)
{
  if(!status_docklet) {
    create_docklet();
  }
  else {
    gtk_widget_destroy(status_docklet);
    status_docklet=NULL;
  }

  /*
   * powinno by tak jak tu ale u mnie nie dziaa (wina fvwm?) :/ --esack
  if(!GTK_WIDGET_VISIBLE(status_docklet)) {
    g_print("szou!!! :D\n");
    gtk_widget_show(status_docklet);
  }
  else {
    g_print("hajd!!!\n");  
    gtk_widget_hide(status_docklet);
  }
  */

}
#endif



void
on_ustawienia1_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  if(!online)
  {
    info("Musisz by poczony z serwerem.");
    return;
  }
  if(!window_prefs)
    my_create_window_prefs();

}


void
on_o_programie1_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  my_create_window_about();
}


void
on_wyloguj_profil1_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
//  GtkWidget *window;
  if(cant_stop)
  {
    info("Nie mona wykona teraz tej operacji.");
    return;
  }

  wyloguj();
  my_create_window_login();
}


void
on_wyj__cie1_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  if(cant_stop)
  {
    info("Nie mona wykona teraz tej operacji.");
    return;
  }
  wyjscie();

}




