/*
Copyright (C) 2002, 2003 Brian Victor Fernandes

This file is part of XMMS mp3cue.

XMMS mp3cue is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

XMMS mp3cue is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with XMMS mp3cue; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

XMMS mp3cue: http://brianvictor.tripod.com/mp3cue.htm
Email: brianv@phreaker.net

Brian Fernandes
503, Miaami Apts. II,
St. Vincents Street,
Pune 411001
INDIA
*/

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include "xmmsctrl.h"
#include "defs.h"
#include <plugin.h>

#include <string>
using namespace std;

GtkWidget *song_name;
GtkWidget *song_artist;
GtkWidget *album_name;
GtkWidget *album_artist;
GtkWidget *song_sec;
GtkWidget *song_min;
GtkWidget *song_frame;
GtkWidget *g_playlist;
GtkWidget *sub_playlist;
GtkWidget *song_menu;
GtkWidget *main_menu;

void create_About (void);
void create_Add_Song (void);
void create_file_prop();
void cresize(GtkWidget *list);
void add_song(GtkWidget *wid, gpointer data);
void add_album(GtkWidget *wid, gpointer data);
void turn_off_album(GtkWidget *wid, gpointer data);
void turn_off_song(GtkWidget *wid, gpointer data);
GtkWidget* create_Song_Menu (void);
GtkWidget* create_Main_Menu (void);
GtkWidget* create_Playlist (void);

extern gchar *album_name_s;
extern gchar *album_artist_s;

extern void hide_list(GtkWidget *playlist, gpointer data);
extern void nextsong();
extern void prevsong();

extern gboolean play_sub_song(GtkWidget *song_list, gint row, gint column, GdkEvent *event);
extern gboolean update_sub_playlist(GtkWidget *song_list, GdkEventButton *event);
extern void remove_sub_song(GtkWidget *song_list, GdkEventButton *event);
extern void edit_sub_song(GtkWidget *song_list, GdkEventButton *event);
extern void dummy();

extern void export_cue_sheet();
extern void import_cue_sheet();
extern void showMainMenu(GtkWidget *dummy, GdkEventButton *event);
extern void SaveID3(GtkWidget *dummy, GdkEvent *dummy_event, gpointer remove);
extern void fixtimes(gint c_row);
extern gint findsong(int time);

 
extern gint s_row, rows, p_row;
extern GeneralPlugin mp3cue;

gint time_width = 80;
#define WIDTH 273

GtkWidget* create_Song_Menu (void);
GtkWidget* create_Main_Menu (void);

GdkColor red = {0, 0xFFFF, 0, 0 };
GdkColor black = {0, 0, 0, 0 };

typedef unsigned char BOOL;
BOOL add_album_on = false;
BOOL add_song_on = false;


void fixcolors(gint redrow, gint blackrow) 
{  
  if(blackrow >= 0) gtk_clist_set_foreground(GTK_CLIST(sub_playlist), blackrow, &black);
  gtk_clist_set_foreground(GTK_CLIST(sub_playlist), redrow, &red);
}


void clean_list()
{
  //make all the elements black...
  for(int i=0;i<rows;i++) 
    gtk_clist_set_foreground(GTK_CLIST(sub_playlist), i, &black);
}


void quick_message(gchar *message) 
{

  GtkWidget *dialog, *label, *okay_button;
  
  
  dialog = gtk_dialog_new();
  label = gtk_label_new (message);
  okay_button = gtk_button_new_with_label("Okay");
  
  
  gtk_signal_connect_object (GTK_OBJECT (okay_button), "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy), (GtkObject *)dialog);
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG(dialog)->action_area),okay_button);

  
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG(dialog)->vbox),
		     label);
  gtk_widget_show_all (dialog);
}


void turn_off_album(GtkWidget *wid, gpointer data) 
{
  add_album_on = false;
}


void turn_off_song(GtkWidget *wid, gpointer data) 
{
  add_song_on = false;
}

void add_album(GtkWidget *wid, gpointer data) 
{
  gchar *temp;
  temp = gtk_entry_get_text(GTK_ENTRY(album_artist));
  album_artist_s = (gchar *)malloc(strlen(temp)+1);
  strcpy(album_artist_s,temp);
  album_artist_s[strlen(temp)] = 0;

  temp = gtk_entry_get_text(GTK_ENTRY(album_name));
  album_name_s = (gchar *)malloc(strlen(temp)+1);
  strcpy(album_name_s,temp);
  album_name_s[strlen(temp)] = 0;

  add_album_on = false;
}


void add_song(GtkWidget *wid, gpointer data) 
{
  gchar *s_name, *a_name;
  gchar *rdata[2], *songart;
  gchar timed[10];
  gint min, sec, frame;
  gint c_row;

  s_name = gtk_entry_get_text(GTK_ENTRY(song_name));
  a_name = gtk_entry_get_text(GTK_ENTRY(song_artist));

  songart = (gchar *)malloc( strlen(s_name) + strlen(a_name) + 4);
  sprintf(songart, "%s ~ %s", a_name, s_name);

  min = atoi(gtk_entry_get_text(GTK_ENTRY(song_min)));
  sec = atoi(gtk_entry_get_text(GTK_ENTRY(song_sec)));
  frame = atoi(gtk_entry_get_text(GTK_ENTRY(song_frame)));

  //add into the playlist also
  PTIME(timed, min, sec, frame);
  timed[9] = 0;
  rdata[0] = songart;  //mess;
  rdata[1] = timed;

  //if srows is not -1 then we update, else add
  if(s_row == -1) {
    gtk_clist_append(GTK_CLIST(sub_playlist),rdata);
    rows++;
  }
 
  else {
    //to maintain the sorted order, remove and append.
    gtk_clist_remove(GTK_CLIST(sub_playlist), s_row);
    gtk_clist_append(GTK_CLIST(sub_playlist), rdata);    
  }
  free(songart);

  //update the time_width
  time_width =  (gtk_clist_optimal_column_width (GTK_CLIST(sub_playlist), 1) > time_width ) ? gtk_clist_optimal_column_width(GTK_CLIST(sub_playlist), 1) : time_width; 

  //if update or add, we have to fix up the time
  c_row = findsong(xmms_remote_get_output_time(mp3cue.xmms_session));
  fixtimes(c_row);

  clean_list();
  fixcolors(p_row = c_row, -1);

  add_song_on = false;
}



void create_About (void)
{
  GtkWidget *About;
  GtkWidget *vbox2;
  GtkWidget *label10;
  GtkWidget *button2;

  About = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_object_set_data (GTK_OBJECT (About), "About", About);
  gtk_window_set_title (GTK_WINDOW (About), "About XMMS mp3cue v" VERSION 
#ifdef DEBUG
			" (DEBUG) " 
#endif
);
  gtk_window_set_policy (GTK_WINDOW (About), TRUE, TRUE, TRUE);

  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox2);
  gtk_object_set_data_full (GTK_OBJECT (About), "vbox2", vbox2,
                            (GtkDestroyNotify) gtk_widget_unref);
  //  gtk_widget_show (vbox2);
  gtk_container_add (GTK_CONTAINER (About), vbox2);

  label10 = gtk_label_new ("XMMS mp3cue Plugin\nby Brian Victor Fernandes <brianv@phreaker.net>\nWebsite: http://brianvictor.tripod.com/mp3cue.htm\n\n Cue sheet support for XMMS.\nNavigate through large mp3s\n(or any other XMMS seekable format) easily.\nStore cue information in ID3v2 tags.\n\nCheck README for more details.\nDocumentation and updates available on website.\n\nPlease send any bug reports to me, they will help immensely. Thanks." 
#ifdef DEBUG
			   "\n\nTHIS IS A DEBUG RELEASE FOR TESTING PURPOSES ONLY\nPLEASE DO NOT DISTRIBUTE" 
#endif
);
  gtk_widget_ref (label10);
  gtk_object_set_data_full (GTK_OBJECT (About), "label10", label10,
                            (GtkDestroyNotify) gtk_widget_unref);
  //  gtk_widget_show (label10);
  gtk_box_pack_start (GTK_BOX (vbox2), label10, FALSE, FALSE, 0);

  button2 = gtk_button_new_with_label ("Close");
  gtk_widget_ref (button2);
  gtk_object_set_data_full (GTK_OBJECT (About), "button2", button2,
                            (GtkDestroyNotify) gtk_widget_unref);
  //  gtk_widget_show (button2);
  gtk_box_pack_end (GTK_BOX (vbox2), button2, FALSE, FALSE, 0);

  gtk_signal_connect_object (GTK_OBJECT (button2), "pressed",
                             GTK_SIGNAL_FUNC (gtk_widget_destroy),
                             GTK_OBJECT (About));
  gtk_widget_show_all(About);
}


void create_file_prop() 
{
  GtkWidget *file_prop, *frame1, *fixed1, *label8, *label9, *button1;

  if(add_album_on) return;
  add_album_on = true;

  file_prop = gtk_window_new (GTK_WINDOW_DIALOG);
  gtk_object_set_data (GTK_OBJECT (file_prop), "file_prop", file_prop);
  gtk_window_set_title (GTK_WINDOW (file_prop), ("File Properties"));
  gtk_window_set_position (GTK_WINDOW (file_prop), GTK_WIN_POS_MOUSE);
  gtk_window_set_policy (GTK_WINDOW (file_prop), FALSE, FALSE, FALSE);

  frame1 = gtk_frame_new (("Song Details"));
  gtk_widget_ref (frame1);
  gtk_object_set_data_full (GTK_OBJECT (file_prop), "frame1", frame1,
                            (GtkDestroyNotify) gtk_widget_unref);
  //  gtk_widget_show (frame1);
  gtk_container_add (GTK_CONTAINER (file_prop), frame1);

  fixed1 = gtk_fixed_new ();
  gtk_widget_ref (fixed1);
  gtk_object_set_data_full (GTK_OBJECT (file_prop), "fixed1", fixed1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_container_set_border_width (GTK_CONTAINER (fixed1), 4);
  //  gtk_widget_show (fixed1);
  gtk_container_add (GTK_CONTAINER (frame1), fixed1);

  album_name = gtk_entry_new ();
  if(album_name_s) gtk_entry_set_text(GTK_ENTRY(album_name), album_name_s);

  gtk_widget_ref (album_name);
  gtk_object_set_data_full (GTK_OBJECT (file_prop), "album_name", album_name,
                            (GtkDestroyNotify) gtk_widget_unref);
  //  gtk_widget_show (album_name);
  gtk_fixed_put (GTK_FIXED (fixed1), album_name, 72, 8);
  gtk_widget_set_uposition (album_name, 72, 8);
  gtk_widget_set_usize (album_name, 158, 20);

  album_artist = gtk_entry_new ();

  //set the contents if it is read
  if(album_artist_s) gtk_entry_set_text(GTK_ENTRY(album_artist), album_artist_s);

  gtk_widget_ref (album_artist);
  gtk_object_set_data_full (GTK_OBJECT (file_prop), "album_artist", album_artist,
                            (GtkDestroyNotify) gtk_widget_unref);
  //  gtk_widget_show (album_artist);
  gtk_fixed_put (GTK_FIXED (fixed1), album_artist, 72, 40);
  gtk_widget_set_uposition (album_artist, 72, 40);
  gtk_widget_set_usize (album_artist, 158, 20);

  label9 = gtk_label_new (("Artist:"));
  gtk_widget_ref (label9);
  gtk_object_set_data_full (GTK_OBJECT (file_prop), "label9", label9,
                            (GtkDestroyNotify) gtk_widget_unref);
  //  gtk_widget_show (label9);
  gtk_fixed_put (GTK_FIXED (fixed1), label9, 8, 40);
  gtk_widget_set_uposition (label9, 8, 40);
  gtk_widget_set_usize (label9, 36, 16);
  gtk_label_set_justify (GTK_LABEL (label9), GTK_JUSTIFY_LEFT);

  label8 = gtk_label_new (("Album:"));
  gtk_widget_ref (label8);
  gtk_object_set_data_full (GTK_OBJECT (file_prop), "label8", label8,
                            (GtkDestroyNotify) gtk_widget_unref);
  //  gtk_widget_show (label8);
  gtk_fixed_put (GTK_FIXED (fixed1), label8, 8, 8);
  gtk_widget_set_uposition (label8, 8, 8);
  gtk_widget_set_usize (label8, 36, 16);
  gtk_label_set_justify (GTK_LABEL (label8), GTK_JUSTIFY_LEFT);

  button1 = gtk_button_new_with_label (("Ok"));
        
  gtk_signal_connect (GTK_OBJECT (button1), "clicked",GTK_SIGNAL_FUNC (add_album), NULL);

  gtk_widget_ref (button1);
  gtk_object_set_data_full (GTK_OBJECT (file_prop), "button1", button1,(GtkDestroyNotify) gtk_widget_unref);
  gtk_signal_connect_object(GTK_OBJECT(button1), "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy), (GtkObject *) file_prop);


  gtk_fixed_put (GTK_FIXED (fixed1), button1, 176, 72);
  gtk_widget_set_uposition (button1, 176, 72);
  gtk_widget_set_usize (button1, 43, 20);


  gtk_signal_connect (GTK_OBJECT (file_prop), "delete_event", GTK_SIGNAL_FUNC(turn_off_album), NULL);
  gtk_signal_connect_object(GTK_OBJECT(file_prop), "delete_event", GTK_SIGNAL_FUNC(gtk_widget_destroy), (GtkObject *) file_prop);


  gtk_widget_show_all(file_prop);

}




void create_Add_Song (void)
{
  GtkWidget *Add_Song;
  GtkWidget *table1;
  GtkWidget *label4;
  GtkWidget *label5;
  GtkWidget *label6;
  GtkWidget *hbox5;
  GtkWidget *button1;

  if(add_song_on) return;
  add_song_on = true;

  Add_Song = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_object_set_data (GTK_OBJECT (Add_Song), "Add_Song", Add_Song);

  table1 = gtk_table_new (3, 2, FALSE);
  gtk_widget_ref (table1);
  gtk_object_set_data_full (GTK_OBJECT (Add_Song), "table1", table1,
                            (GtkDestroyNotify) gtk_widget_unref);
  //  gtk_widget_show (table1);
  gtk_container_add (GTK_CONTAINER (Add_Song), table1);
  gtk_container_set_border_width (GTK_CONTAINER (table1), 7);
  gtk_table_set_row_spacings (GTK_TABLE (table1), 8);

  label4 = gtk_label_new ("Song Name:");
  gtk_widget_ref (label4);
  gtk_object_set_data_full (GTK_OBJECT (Add_Song), "label4", label4,
                            (GtkDestroyNotify) gtk_widget_unref);
  //  gtk_widget_show (label4);
  gtk_table_attach (GTK_TABLE (table1), label4, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label4), 0, 0.5);

  label5 = gtk_label_new ("Artist:");
  gtk_widget_ref (label5);
  gtk_object_set_data_full (GTK_OBJECT (Add_Song), "label5", label5,
                            (GtkDestroyNotify) gtk_widget_unref);
  //  gtk_widget_show (label5);
  gtk_table_attach (GTK_TABLE (table1), label5, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label5), 0, 0.5);

  label6 = gtk_label_new ("Time:");
  gtk_widget_ref (label6);
  gtk_object_set_data_full (GTK_OBJECT (Add_Song), "label6", label6,
                            (GtkDestroyNotify) gtk_widget_unref);
  //  gtk_widget_show (label6);
  gtk_table_attach (GTK_TABLE (table1), label6, 0, 1, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label6), 0, 0.5);

  song_artist = gtk_entry_new ();
  gtk_widget_ref (song_artist);
  gtk_object_set_data_full (GTK_OBJECT (Add_Song), "song_artist", song_artist,
                            (GtkDestroyNotify) gtk_widget_unref);
  //  gtk_widget_show (song_artist);
  gtk_table_attach (GTK_TABLE (table1), song_artist, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  song_name = gtk_entry_new ();
  gtk_widget_ref (song_name);
  gtk_object_set_data_full (GTK_OBJECT (Add_Song), "song_name", song_name,
                            (GtkDestroyNotify) gtk_widget_unref);
  //  gtk_widget_show (song_name);
  gtk_table_attach (GTK_TABLE (table1), song_name, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  hbox5 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox5);
  gtk_object_set_data_full (GTK_OBJECT (Add_Song), "hbox5", hbox5,
                            (GtkDestroyNotify) gtk_widget_unref);
  //  gtk_widget_show (hbox5);
  gtk_table_attach (GTK_TABLE (table1), hbox5, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  song_min = gtk_entry_new_with_max_length (3);
  gtk_widget_ref (song_min);
  gtk_object_set_data_full (GTK_OBJECT (Add_Song), "song_min", song_min,
                            (GtkDestroyNotify) gtk_widget_unref);
  //  gtk_widget_show (song_min);
  gtk_box_pack_start (GTK_BOX (hbox5), song_min, FALSE, TRUE, 0);
  gtk_widget_set_usize (song_min, 30, -2);

  song_sec = gtk_entry_new_with_max_length (2);
  gtk_widget_ref (song_sec);
  gtk_object_set_data_full (GTK_OBJECT (Add_Song), "song_sec", song_sec,
                            (GtkDestroyNotify) gtk_widget_unref);
  //  gtk_widget_show (song_sec);
  gtk_box_pack_start (GTK_BOX (hbox5), song_sec, FALSE, TRUE, 0);
  gtk_widget_set_usize (song_sec, 24, -2);

  song_frame = gtk_entry_new_with_max_length (2);
  gtk_widget_ref (song_frame);
  gtk_object_set_data_full (GTK_OBJECT (Add_Song), "song_frame", song_frame,
                            (GtkDestroyNotify) gtk_widget_unref);
  //  gtk_widget_show (song_frame);
  gtk_box_pack_start (GTK_BOX (hbox5), song_frame, FALSE, TRUE, 0);
  gtk_widget_set_usize (song_frame, 24, -2);

  if(s_row >= 0) {
    gtk_window_set_title (GTK_WINDOW (Add_Song), "Update Song");

    //ok this must not be add, but edit .. woohoo
    static gchar mess[5];
    gint whole, second, min, sec, frame;
    gchar *songart, *songtime, *tilda, *artist;

    gtk_clist_get_text(GTK_CLIST(sub_playlist),s_row,0,&songart);
    gtk_clist_get_text(GTK_CLIST(sub_playlist),s_row,1,&songtime);

    //divide songeart into song and artist
    tilda = strrchr(songart, '~');
    whole = strlen(songart);
    second = strlen(tilda);
    artist  = (gchar *)malloc(whole-second);
    strncpy(artist,songart,(whole-second-1));
    artist[whole-second-1] = 0;
    gtk_entry_set_text(GTK_ENTRY(song_artist),artist);
    free(artist);
    gtk_entry_set_text(GTK_ENTRY(song_name),tilda+2);

    SCANTIME(songtime,min,sec,frame);
    sprintf(mess,"%d",min);
    gtk_entry_set_text(GTK_ENTRY(song_min),mess);
    sprintf(mess,"%d",sec);
    gtk_entry_set_text(GTK_ENTRY(song_sec),mess);
    sprintf(mess,"%d",frame);
    gtk_entry_set_text(GTK_ENTRY(song_frame),mess);

    button1 = gtk_button_new_with_label (("Update"));
  }

  else {
    gtk_window_set_title (GTK_WINDOW (Add_Song), "Add Song");
    button1 = gtk_button_new_with_label (("Add"));
  }
        
  gtk_signal_connect (GTK_OBJECT (button1), "clicked",
		      GTK_SIGNAL_FUNC (add_song),
		      NULL);

  gtk_widget_ref (button1);
  gtk_object_set_data_full (GTK_OBJECT (Add_Song), "button1", button1,
			    (GtkDestroyNotify) gtk_widget_unref);
  //  gtk_widget_show (button1);


  gtk_box_pack_end (GTK_BOX (hbox5), button1, TRUE, TRUE, 4);

  gtk_signal_connect_object(GTK_OBJECT(button1), "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy), (GtkObject *) Add_Song);


  gtk_signal_connect (GTK_OBJECT (Add_Song), "delete_event", GTK_SIGNAL_FUNC(turn_off_song), NULL);
  gtk_signal_connect_object(GTK_OBJECT(Add_Song), "delete_event", GTK_SIGNAL_FUNC(gtk_widget_destroy), (GtkObject *) Add_Song);


  gtk_widget_show_all(Add_Song);

}


void cresize(GtkWidget *list)
{
  //resize the song title according to the new clist size
  gtk_clist_set_column_width(GTK_CLIST(sub_playlist),0, sub_playlist->allocation.width-time_width);
}

GtkWidget* create_Playlist (void)
{
  GtkWidget *Playlist;
  GtkWidget *vbox1;
  GtkWidget *scrolledwindow1;
  GtkWidget *hbox6;
  GtkWidget *next;
  GtkWidget *prev;
  GtkAccelGroup *accel_group;

  accel_group = gtk_accel_group_new ();

  Playlist = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_object_set_data (GTK_OBJECT (Playlist), "Playlist", Playlist);
  gtk_window_set_title (GTK_WINDOW (Playlist), "mp3Cue Playlist");
  gtk_window_set_policy(GTK_WINDOW (Playlist), FALSE, TRUE, FALSE);
 
  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox1);
  gtk_object_set_data_full (GTK_OBJECT (Playlist), "vbox1", vbox1,
                            (GtkDestroyNotify) gtk_widget_unref);
  //  gtk_widget_show (vbox1);
  gtk_container_add (GTK_CONTAINER (Playlist), vbox1);

  scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_ref (scrolledwindow1);
  gtk_object_set_data_full (GTK_OBJECT (Playlist), "scrolledwindow1", scrolledwindow1,
                            (GtkDestroyNotify) gtk_widget_unref);
  //  gtk_widget_show (scrolledwindow1);
  gtk_box_pack_start (GTK_BOX (vbox1), scrolledwindow1, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1), GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);

  sub_playlist = gtk_clist_new (2);
  gtk_widget_ref (sub_playlist);
  gtk_object_set_data_full (GTK_OBJECT (Playlist), "sub_playlist", sub_playlist,
                            (GtkDestroyNotify) gtk_widget_unref);
  //  gtk_widget_show (sub_playlist);
  gtk_container_add (GTK_CONTAINER (scrolledwindow1), sub_playlist);
  gtk_widget_set_usize (sub_playlist, 265, 120);


  gtk_clist_set_column_width (GTK_CLIST (sub_playlist), 0, 150);
  gtk_clist_set_column_min_width (GTK_CLIST (sub_playlist), 0, 150);

  gtk_clist_set_column_width (GTK_CLIST (sub_playlist), 1, 80);
  gtk_clist_set_column_min_width (GTK_CLIST (sub_playlist), 1, 80);


  gtk_signal_connect_after(GTK_OBJECT(Playlist), "check_resize", GTK_SIGNAL_FUNC(cresize),scrolledwindow1);


  hbox6 = gtk_hbox_new (FALSE, 10);
  gtk_widget_ref (hbox6);
  gtk_object_set_data_full (GTK_OBJECT (Playlist), "hbox6", hbox6,
                            (GtkDestroyNotify) gtk_widget_unref);
  //  gtk_widget_show (hbox6);
  


  prev = gtk_button_new_with_label ("  Prev  ");
  gtk_widget_ref (prev);
  gtk_object_set_data_full (GTK_OBJECT (Playlist), "prev", prev,
                            (GtkDestroyNotify) gtk_widget_unref);
  //  gtk_widget_show (prev);
  gtk_box_pack_start (GTK_BOX (hbox6), prev, FALSE, FALSE, 0);
  gtk_widget_add_accelerator (prev, "clicked", accel_group,
                              GDK_comma, 0,
                              GTK_ACCEL_VISIBLE);

  next = gtk_button_new_with_label ("  Next  ");
  gtk_widget_ref (next);
  gtk_object_set_data_full (GTK_OBJECT (Playlist), "next", next,
                            (GtkDestroyNotify) gtk_widget_unref);
  //  gtk_widget_show (next);
  gtk_box_pack_start (GTK_BOX (hbox6), next, FALSE, FALSE, 0);
  gtk_widget_add_accelerator (next, "clicked", accel_group,
                              GDK_period, 0,
                              GTK_ACCEL_VISIBLE);


  GtkWidget *eventbox = gtk_event_box_new();
  gtk_box_pack_start (GTK_BOX (vbox1), eventbox, FALSE, FALSE, 0);
  gtk_container_add(GTK_CONTAINER(eventbox), hbox6);
  //  gtk_widget_show(eventbox);

  gtk_widget_set_events(eventbox, GDK_BUTTON_PRESS_MASK);



  gtk_signal_connect (GTK_OBJECT (Playlist), "delete_event",
                      GTK_SIGNAL_FUNC (hide_list),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (sub_playlist), "select_row",
                      GTK_SIGNAL_FUNC (play_sub_song),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (sub_playlist), "button_press_event",
                      GTK_SIGNAL_FUNC (update_sub_playlist),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (eventbox), "button_press_event",
                      GTK_SIGNAL_FUNC (showMainMenu),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (next), "clicked",
                      GTK_SIGNAL_FUNC (nextsong),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (prev), "clicked",
                      GTK_SIGNAL_FUNC (prevsong),
                      NULL);

  gtk_window_add_accel_group (GTK_WINDOW (Playlist), accel_group);

  //create the menus
  song_menu = create_Song_Menu();
  main_menu = create_Main_Menu();

  //set the sorting properties of the list
  gtk_clist_set_sort_type(GTK_CLIST(sub_playlist), GTK_SORT_ASCENDING);
  gtk_clist_set_auto_sort(GTK_CLIST(sub_playlist), TRUE);
  gtk_clist_set_sort_column(GTK_CLIST(sub_playlist), 1);
  
  gtk_widget_show_all(Playlist);

  return Playlist;
}





GtkWidget* create_Main_Menu (void)
{
  GtkWidget *mi_add_song;
  GtkWidget *mi_export_cue;
  GtkWidget *mi_import_cue;
  GtkWidget *mi_properties;
  GtkWidget *mi_save_to_mp3;
  GtkWidget *mi_remove_from_mp3;

  main_menu = gtk_menu_new();
  mi_add_song = gtk_menu_item_new_with_label("Add Track");
  mi_export_cue = gtk_menu_item_new_with_label("Export Cue Sheet");
  mi_import_cue = gtk_menu_item_new_with_label("Import Cue Sheet");
  mi_properties = gtk_menu_item_new_with_label("Properties");
  mi_save_to_mp3 = gtk_menu_item_new_with_label("Save to MP3");
  mi_remove_from_mp3 = gtk_menu_item_new_with_label("Remove Frame");
  
  
  gtk_menu_append(GTK_MENU(main_menu),mi_add_song);
  gtk_menu_append(GTK_MENU(main_menu),mi_export_cue);
  gtk_menu_append(GTK_MENU(main_menu),mi_import_cue);
  gtk_menu_append(GTK_MENU(main_menu),mi_properties);
  gtk_menu_append(GTK_MENU(main_menu),mi_save_to_mp3);
  gtk_menu_append(GTK_MENU(main_menu),mi_remove_from_mp3);

  gtk_signal_connect(GTK_OBJECT(mi_add_song), "button_press_event", GTK_SIGNAL_FUNC(create_Add_Song), NULL);
  gtk_signal_connect(GTK_OBJECT(mi_export_cue), "button_press_event", GTK_SIGNAL_FUNC(export_cue_sheet), NULL);
  gtk_signal_connect(GTK_OBJECT(mi_import_cue), "button_press_event", GTK_SIGNAL_FUNC(import_cue_sheet), NULL);
  gtk_signal_connect(GTK_OBJECT(mi_properties), "button_press_event", GTK_SIGNAL_FUNC(create_file_prop), NULL);
  gtk_signal_connect(GTK_OBJECT(mi_save_to_mp3), "button_press_event", GTK_SIGNAL_FUNC(SaveID3), NULL);
  gtk_signal_connect(GTK_OBJECT(mi_remove_from_mp3), "button_press_event", GTK_SIGNAL_FUNC(SaveID3), GINT_TO_POINTER(1));

  gtk_widget_show_all(main_menu);
  return main_menu;

}

GtkWidget* create_Song_Menu (void)
{
  GtkWidget *mi_edit_song;
  GtkWidget *mi_remove_song;

  //Create the individual song menu's 
  song_menu = gtk_menu_new();
  mi_edit_song = gtk_menu_item_new_with_label("Edit");
  mi_remove_song = gtk_menu_item_new_with_label("Remove");

  gtk_menu_append(GTK_MENU(song_menu),mi_edit_song);
  gtk_menu_append(GTK_MENU(song_menu),mi_remove_song);
  gtk_signal_connect_object(GTK_OBJECT(mi_edit_song), "button_press_event", GTK_SIGNAL_FUNC(edit_sub_song), NULL);
  gtk_signal_connect_object(GTK_OBJECT(mi_remove_song), "button_press_event", GTK_SIGNAL_FUNC(remove_sub_song), NULL);

  gtk_widget_show_all(song_menu);
 
  return song_menu;
}
