/* File:      array1.P
** Author(s): Jiyang Xu, Kostis Sagonas
** Contact:   xsb-contact@cs.sunysb.edu
** 
** Copyright (C) The Research Foundation of SUNY, 1986, 1993-1998
** Copyright (C) ECRC, Germany, 1990
** 
** XSB is free software; you can redistribute it and/or modify it under the
** terms of the GNU Library General Public License as published by the Free
** Software Foundation; either version 2 of the License, or (at your option)
** any later version.
** 
** XSB is distributed in the hope that it will be useful, but WITHOUT ANY
** WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
** FOR A PARTICULAR PURPOSE.  See the GNU Library General Public License for
** more details.
** 
** You should have received a copy of the GNU Library General Public License
** along with XSB; if not, write to the Free Software Foundation,
** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
** $Id: array1.P,v 1.1.1.1 1998/11/05 17:00:25 sbprolog Exp $
** 
*/


/*======================================================================*/
/* A simpler array implementation: only one version is valid.		*/
/*    --  Older versions are replaced by an invalid flag.		*/
/*    --  backtrackable							*/
/*======================================================================*/

:- export array_new/2, array_elt/3, array_update/4.

:- import functor/3, arg/3 from standard.
:- import term_set_arg/4 from machine.

/* -- array : backtrackable --------------------------------------*/

array_new(A, Size) :- functor(A, array, Size).

array_elt(A, I, V) :- arg(I, A, V).

array_update(A, I, V, A) :- term_set_arg(A, I, V, 0).

/* implementation without value trail --- 

array_update(A, I, V, A) :-
	arg(I, A, VL),
	( var(VL), !, VL = V			% if var, just set it
	;
	   ( term_set_arg(A, I, V, 1)
	   ; term_set_arg(A, I, VL, 1), fail
	   )
	).
*/

/* TEST

import array_new/2 from array1.
import array_elt/3 from array1.
import array_update/4 from array1.
array_new(A, 4), array_update(A,1,1,B), array_update(B,2,2,C),
	( array_update(C,3,3,D), array_elt(D,3,E4)
	; array_update(C,3,6,E), array_elt(E,3,E5)
	; array_update(C,3,7,F), array_elt(F,3,E6)
	),
	array_elt(A,3,E1),array_elt(B,3,E2),array_elt(C,3,E3).

*/
