/* File:      arith_r.P
** Author(s): Christian Holzbaur (see below)
**	      (modified by Baoqiu Cui to make it work in XSB)
**
** $Id: arith_r.P,v 1.2 2000/06/09 13:46:48 cbaoqiu Exp $
** 
*/

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  clp(q,r)                                         version 1.3.3 %
%                                                                 %
%  (c) Copyright 1992,1993,1994,1995                              %
%  Austrian Research Institute for Artificial Intelligence (OFAI) %
%  Schottengasse 3                                                %
%  A-1010 Vienna, Austria                                         %
%                                                                 %
%  File:   arith_r.pl                                             %
%  Author: Christian Holzbaur           christian@ai.univie.ac.at %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

:- export arith_eps/1,
	  arith_normalize/2,
	  integerp/1,
	  integerp/2,
	  arith_eval/1,
	  arith_eval/2,
	  case_signum/4.

:- import compile_R/3,
	  l2conj/2,
	  rat_float/3,
	  compile_case_signum_R/5
   from arith.


arith_eval(Term, Res) :-
	compile_R(Term, Res, Code),
	l2conj(Code, Expansion),
	call(Expansion).

arith_eval(Rel) :-
	compile_R(Rel, boolean, Code),
	l2conj(Code, Expansion),
	call(Expansion).

case_signum(Term, Lt, Z, Gt) :-
	compile_case_signum_R(Term, Lt, Z, Gt, Code),
	l2conj(Code, Expansion),
	call(Expansion).


% This the only place where this constant lives
%
arith_eps( 1.0e-10).			% for Monash #zero expansion 1.0e-12
% eps( 1.0e-10, -1.0e-10).

arith_normalize(X, Norm) :-
	var(X), !, 
	write(instantiation_error(arith_normalize(X,Norm),1)), nl,
	abort.
arith_normalize(rat(N,D), Norm) :-
	rat_float( N,D, Norm).
arith_normalize(X, Norm) :-
	number(X),
	Norm is float(X).

integerp(X) :-
	floor(X)=:=X.

integerp(X, I) :-
	floor(X)=:=X,
% 	I is integer(X).
	I is floor(X).
