/* File:      flora2.P
**
** Author(s): Michael Kifer
**            Guizhen Yang
**
** Contact:   flora-users@lists.sourceforge.net
** 
** Copyright (C) The Research Foundation of SUNY, 1998 - 2002
** 
** FLORA-2 is free software; you can redistribute it and/or modify it under the
** terms of the GNU Library General Public License as published by the Free
** Software Foundation; either version 2 of the License, or (at your option)
** any later version.
** 
** FLORA-2 is distributed in the hope that it will be useful, but WITHOUT ANY
** WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
** FOR A PARTICULAR PURPOSE.  See the GNU Library General Public License for
** more details.
** 
** You should have received a copy of the GNU Library General Public License
** along with FLORA-2; if not, write to the Free Software Foundation,
** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
**
** $Id: flora2.P,v 1.5 2003/06/18 07:01:37 kifer Exp $
** 
*/


:- compiler_options([xpp_on]).


:- import
	bootstrap_package/2,
	package_configuration/2,
	unload_package/1
   from packaging.

:- import
	flImportPredicate/4
   from flrimport.

:- import
	flora_load_module_internal/2, flora_load_module_internal/1,
	flora_compile_internal/2, flora_compile_internal/1
   from flrutils.

:- import flora_configuration/2,
	flora_module_registry/1
   from flrregistry.

:- import flora_sysmod_file/3 from flrlibman.

:- import slash/1 from machine.
:- import str_cat/3 from string.

:- import flora_shell_loop/0 from usermod.

:- import hide_this_show/2 from usermod.

:- import conget/2, conset/2 from gensym.

:- import xpp_include_dir/1 from parse.

:- dynamic hide_this_show(_,_).
:- index(hide_this_show/2,trie).

:- export
	bootstrap_flora/0,
	unstrap_flora/0,
	(flImport)/1,
	(flLoad)/1,
	(flCompile)/1,
	flLoadedModule/1,
	flora_shell/0.


/*****************************************************************************/


bootstrap_flora :-
	%% Just check if flora_configuration is defined --
	%% don't load flrregistry at this early stage
	(current_predicate(flrregistry:flora_configuration/2)
	-> \+flora_configuration(loaded,yes)
	;  true
	),
	(
	  current_predicate(flrregistry:flora_configuration/2),
	  %% running FLORA as a development version
	  flora_configuration(develmode,yes),
	  !,
	  flora_configuration(installdir,FloraDir)
	;
	  %% running FLORA as a package
	  bootstrap_package([flora2,syslib,lib,debugger,pkgs,p2h],flora),
	  (flora_configuration(develmode,yes)
	  -> abort('FLORA-2 has been loaded as a standalone application: quit XSB then run FLORA as a package')
	  ; true
	  ),
	  assert(flora_configuration(develmode,no)),
	  [flrversion],
	  package_configuration(dir(flora),FloraDir),
	  assert(flora_configuration(installdir,FloraDir))
	),
	!,
	assert(flora_configuration(loaded,yes)),
	slash(S),
	concat_atoms([FloraDir,S,closure],Closure),
	concat_atoms([FloraDir,S,includes],Includes),
	concat_atoms([FloraDir,S,flrincludes],FlrIncludes),
	concat_atoms([FloraDir,S,genincludes],GenIncludes),
	assert(xpp_include_dir(Closure)),
	assert(xpp_include_dir(Includes)),
	assert(xpp_include_dir(FlrIncludes)),
	assert(xpp_include_dir(GenIncludes)),
	assert(flora_configuration(includedirs, [Closure,Includes,FlrIncludes,GenIncludes])),
	[p2h_config].

bootstrap_flora.


/*****************************************************************************/
unstrap_flora :-
	flora_configuration(includedirs,IncludeDirs),
	remove_include_dirs(IncludeDirs),
	(flora_configuration(develmode,yes), ! ; unload_package(flora)),
	retractall(flora_configuration(loaded,_)),
	conset(flora_shell_loaded,0).


/*****************************************************************************/
%% don''t show flora_shell in trace
:- assert(hide_this_show(flora_shell,0)). 


/*****************************************************************************/
flora_shell :-
	bootstrap_flora,
	notrace,
	( conget(flora_shell_loaded,1), !
	;
	  consult(flrshell),
	  flora_shell_loop
	).

/************************************************************************
  Flora import stuff

  Syntax:
      :- flImport Pred/Arity as Pred1(_,_,...) from File[.flr]>>FloraModule
  or
      :- flImport Pred/Arity as Pred1(_,_,...) from FloraModule

  Also (to load into the default module)
      :- flLoad file.
  or
      :- flLoad file>>module.

  To compile (without loading):
      :- flCompile file.
  or
      :- flCompile file>>module.
************************************************************************/

:- op(500,yfx,(as)).
:- op(1170,fx,(flImport)).

:- op(1050,fx,(flLoad)).	% loads file into module: flLoad(File>>Module)
      % compiles file for loading into module: flCompile(File>>Module)
:- op(1050,fx,(flCompile)).
%% The other operators, '>>' and 'from', are already defined in Prolog

flImport(from(as(What,AsWhat),FileMod)) :- !,
	(atom(FileMod)  % in this case FileMod is a module name
	-> (flLoadedModule(FileMod)
	   -> flImportPredicate(What,AsWhat,_,FileMod)
	   ;  abort(['Trying to import hilog predicate ', What,
		     ' from unloaded FLORA module ', FileMod])
	   )
	; FileMod = File>>Module 
	-> flImportPredicate(What,AsWhat,File,Module)
	).

flImport(X) :- abort(['Invalid flImport syntax: ', X]).

flLoad(File>>Module) :- flora_load_module_internal(File,Module).
flLoad(Module) :- flora_load_module_internal(Module).

flCompile(File>>Module) :- flora_compile_internal(File,Module).
flCompile(Module) :- flora_compile_internal(Module).

%% tells if ModuleName is loaded
flLoadedModule(ModuleName) :- 
	flora_module_registry(ModuleName),
	\+ flora_sysmod_file(ModuleName,_,_).


/***************************************************************************/
%% Some utilities that must be duplicated here because they can't be imported

remove_include_dirs([]).
remove_include_dirs([H|T]) :-
	(retract(xpp_include_dir(H)) ; true),
	remove_include_dirs(T).


concat_atoms([Atom1,Atom2],Atom) :- !, str_cat(Atom1,Atom2,Atom).
concat_atoms([Atom1|AtomList],Atom) :-
	concat_atoms(AtomList,Atom2),
	str_cat(Atom1,Atom2,Atom).
concat_atoms([],'').
	
