/* File:      flora2devel.P
**
** Author(s): Michael Kifer
**
** Contact:   flora-users@lists.sourceforge.net
** 
** Copyright (C) The Research Foundation of SUNY, 2002
** 
** FLORA-2 is free software; you can redistribute it and/or modify it under the
** terms of the GNU Library General Public License as published by the Free
** Software Foundation; either version 2 of the License, or (at your option)
** any later version.
** 
** FLORA-2 is distributed in the hope that it will be useful, but WITHOUT ANY
** WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
** FOR A PARTICULAR PURPOSE.  See the GNU Library General Public License for
** more details.
** 
** You should have received a copy of the GNU Library General Public License
** along with FLORA-2; if not, write to the Free Software Foundation,
** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
**
** $Id: flora2devel.P,v 1.5 2003/06/18 07:01:37 kifer Exp $
** 
*/



:- import flora_configuration/2 from flrregistry.
:- import flora_concat_atoms/2,
	flora_file_op/3,
	flora_slash/1
    from flrporting.


?- current_predicate(flrregistry:flora_configuration/2),
   flora_configuration(develmode,no),
   abort('FLORA-2 is already loaded as a package: quit XSB then use `runflora''').

?- %% Test if we are in the flora install directory
   %% If not then put .. on the module load path, because this means that
   %% we are in a subdirectory of the flora installation directory.
   %% This is needed when flora2devel is caled from the make file.
   catch((flora_slash(_), FloraInstallDirAbbrev='.'),
	 _,
	 %% This happens only in the make file
	 (asserta(library_directory('..')), FloraInstallDirAbbrev = '..')
	),

   %% clean up flora_configuration
   retractall(flora_configuration(version,_)),
   retractall(flora_configuration(develmode,_)),

   (flora_configuration(installdir,FloraInstallDir), !,
       asserta(library_directory(FloraInstallDir))
   ; 
       %% Called from a makefile. In this case library_directory has '..' or
       %% we are running in the Flora install dir and library_directory has '.'
       flora_file_op(expand,FloraInstallDirAbbrev,FloraInstallDirExpanded),
       assert(flora_configuration(installdir,FloraInstallDirExpanded))
   ),

   assert(flora_configuration(develmode,yes)),
   [flrversion],
   flora_assert_directories([syslib,lib,debugger,pkgs,p2h]).

?- flora_slash(S),
   flora_configuration(installdir,FloraInstallDir),
   flora_concat_atoms([FloraInstallDir,S,flora2], Flora2),
   [Flora2].


flora_assert_directories([]).
flora_assert_directories([H|T]) :-
	flora_slash(S),
	flora_configuration(installdir,FloraInstallDir),
	flora_concat_atoms([FloraInstallDir,S,H], Directory),
	assert(library_directory(Directory)),
	flora_assert_directories(T).
