/* File:      flrarguments.P -- Flora argument type definitions
**
** Author(s): Guizhen Yang
**
** Contact:   flora-users@lists.sourceforge.net
**
** Copyright (C) The Research Foundation of SUNY, 1999-2001
** 
** FLORA-2 is free software; you can redistribute it and/or modify it under the
** terms of the GNU Library General Public License as published by the Free
** Software Foundation; either version 2 of the License, or (at your option)
** any later version.
** 
** FLORA-2 is distributed in the hope that it will be useful, but WITHOUT ANY
** WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
** FOR A PARTICULAR PURPOSE.  See the GNU Library General Public License for
** more details.
** 
** You should have received a copy of the GNU Library General Public License
** along with FLORA-2; if not, write to the Free Software Foundation,
** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
** $Id: flrarguments.P,v 1.15 2003/06/18 07:01:37 kifer Exp $
**
*/


:- compiler_options([xpp_on]).

#include "flora_terms.flh"


flora_arguments_spec((findall),3,[FL_OID,FL_BODYFORMULA,FL_OID]) :- !.
flora_arguments_spec(call,1,[FL_BODYFORMULA]) :- !.
flora_arguments_spec(get_residual,2,[FL_BODYFORMULA,FL_OID]) :- !.
flora_arguments_spec(table_state,2,[FL_BODYFORMULA,FL_OID]) :- !.


/****************************************************************************
  flora_argdef(+Functor,+Arity,+ArgsList)
****************************************************************************/
flora_argdef(X,Y,Z) :-
	flora_arguments_spec(X,Y,Z),
	!.

flora_argdef(X,Y,Z) :-
	( conget(flora_shell_mode,1) ->
	    flora_sharg(X,Y,Z)
	;
	  flora_dynarg(X,Y,Z)
	).


/****************************************************************************
  flora_conflict_arguments(+Op,+Arity,+Args)
****************************************************************************/
flora_conflict_arguments(O,A,Args) :-
	flora_arguments_spec(O,_A,_Args),
	(A \= _A; Args \= _Args).


/****************************************************************************
  flora_reset_arguments/0
****************************************************************************/
flora_reset_arguments :- retractall(flora_dynarg(_,_,_)).


/****************************************************************************
  flora_define_arguments(+Op,+Arity,+Args)
****************************************************************************/
flora_define_arguments(Op,Arity,Args) :-
	( flora_arguments_spec(Op,Arity,Args) ->
	    true

	; flora_dynarg(Op,Arity,_) ->
	    retractall(flora_dynarg(Op,Arity,_)),
	    assert(flora_dynarg(Op,Arity,Args))
	;
	  assert(flora_dynarg(Op,Arity,Args))
	).


/****************************************************************************
  flora_shreset_arguments/0
****************************************************************************/
flora_shreset_arguments :- retractall(flora_sharg(_,_,_)).


/****************************************************************************
  flora_shdefine_arguments(+Op,+Arity,+Args)
****************************************************************************/
flora_shdefine_arguments(Op,Arity,Args) :-
	( flora_arguments_spec(Op,Arity,Args) ->
	    true

	; flora_sharg(Op,Arity,_) ->
	    retractall(flora_sharg(Op,Arity,_)),
	    assert(flora_sharg(Op,Arity,Args))
	;
	  assert(flora_sharg(Op,Arity,Args))
	).
