/* File:      flrnodefp.P -- Flora standard predicates disallowing redefinition
**
** Author(s): Guizhen Yang
**
** Contact:   flora-users@lists.sourceforge.net
**
** Copyright (C) The Research Foundation of SUNY, 1999-2001
** 
** FLORA-2 is free software; you can redistribute it and/or modify it under the
** terms of the GNU Library General Public License as published by the Free
** Software Foundation; either version 2 of the License, or (at your option)
** any later version.
** 
** FLORA-2 is distributed in the hope that it will be useful, but WITHOUT ANY
** WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
** FOR A PARTICULAR PURPOSE.  See the GNU Library General Public License for
** more details.
** 
** You should have received a copy of the GNU Library General Public License
** along with FLORA-2; if not, write to the Free Software Foundation,
** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
**
*/


:- compiler_options([xpp_on]).

#include "flora_terms.flh"


:- index flora_nodefp/2-1.

%% These are predicates that are not supposed to have definitions.
%% Parser issues errors when these occur in the head of a rule.

%% PROLOG builtins

flora_nodefp(FL_SEMICOLON,2) :- !.
flora_nodefp(FL_COMMA,2) :- !.

flora_nodefp(FL_TNOT,1) :- !.
flora_nodefp(FL_NEG,1) :- !.

flora_nodefp(FL_UNIVEQ,2) :- !.
flora_nodefp(FL_UNIVNOTEQ,2) :- !.
flora_nodefp(FL_EQ,2) :- !.
flora_nodefp(FL_NOTEQ,2) :- !.
flora_nodefp(FL_ORDERLT,2) :- !.
flora_nodefp(FL_ORDEREQLT,2) :- !.
flora_nodefp(FL_ORDERGT,2) :- !.
flora_nodefp(FL_ORDEREQGT,2) :- !.
flora_nodefp(FL_IS,2) :- !.
flora_nodefp(FL_MATHEQ,2) :- !.
flora_nodefp(FL_MATHNOTEQ,2) :- !.
flora_nodefp(FL_LT,2) :- !.
flora_nodefp(FL_EQLT,2) :- !.
flora_nodefp(FL_GT,2) :- !.
flora_nodefp(FL_EQGT,2) :- !.
flora_nodefp(FL_RIGHTTO,2) :- !.
flora_nodefp(FL_LEFTTO,2) :- !.

flora_nodefp(FL_CUT,0) :- !.

flora_nodefp(FL_IMPLYOP,2) :- !.
flora_nodefp(FL_IMPLYOP,1) :- !.
flora_nodefp(FL_QUERYOP,1) :- !.

%% FLORA builtins
flora_nodefp(FL_UNIVEQFORM,2) :- !.
flora_nodefp(FL_REIFYOP,1) :- !.
flora_nodefp(FL_METAUNIV,2) :- !.

%% FLORA special syntax
flora_nodefp(FL_WHILE,1) :- !.
flora_nodefp(FL_LOOP,1) :- !.
flora_nodefp(FL_DO,1) :- !.
flora_nodefp(FL_DO,2) :- !.
flora_nodefp(FL_UNTIL,2) :- !.

flora_nodefp(FL_IF,1) :- !.
flora_nodefp(FL_UNLESS,1) :- !.
flora_nodefp(FL_THEN,2) :- !.
flora_nodefp(FL_ELSE,2) :- !.
