/* File:      flrnowsp.P -- Flora standard predicates disallowing workspace
**
** Author(s): Guizhen Yang
**
** Contact:   flora-users@lists.sourceforge.net
**
** Copyright (C) The Research Foundation of SUNY, 1999-2001
**
** FLORA-2 is free software; you can redistribute it and/or modify it under the
** terms of the GNU Library General Public License as published by the Free
** Software Foundation; either version 2 of the License, or (at your option)
** any later version.
** 
** FLORA-2 is distributed in the hope that it will be useful, but WITHOUT ANY
** WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
** FOR A PARTICULAR PURPOSE.  See the GNU Library General Public License for
** more details.
** 
** You should have received a copy of the GNU Library General Public License
** along with FLORA-2; if not, write to the Free Software Foundation,
** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
**
*/


:- compiler_options([xpp_on]).

#include "flora_terms.flh"


:- index flora_nowsp/2-1.

%% These are predicates that aren't supposed to have associated workspaces
%% Used by parser to issue syntax errors

%% PROLOG builtins

flora_nowsp(FL_SEMICOLON,2).
flora_nowsp(FL_COMMA,2).
flora_nowsp(FL_TNOT,1).
flora_nowsp(FL_NEG,1).

flora_nowsp(FL_UNIVEQ,2) :- !.
flora_nowsp(FL_UNIVNOTEQ,2) :- !.
flora_nowsp(FL_EQ,2) :- !.
flora_nowsp(FL_NOTEQ,2) :- !.
flora_nowsp(FL_ORDERLT,2) :- !.
flora_nowsp(FL_ORDEREQLT,2) :- !.
flora_nowsp(FL_ORDERGT,2) :- !.
flora_nowsp(FL_ORDEREQGT,2) :- !.
flora_nowsp(FL_METAUNIV,2) :- !.
flora_nowsp(FL_METAUNIVFORM,2) :- !.
flora_nowsp(FL_IS,2) :- !.
flora_nowsp(FL_MATHEQ,2) :- !.
flora_nowsp(FL_MATHNOTEQ,2) :- !.
flora_nowsp(FL_LT,2) :- !.
flora_nowsp(FL_EQLT,2) :- !.
flora_nowsp(FL_GT,2) :- !.
flora_nowsp(FL_EQGT,2) :- !.
flora_nowsp(FL_RIGHTTO,2) :- !.
flora_nowsp(FL_LEFTTO,2) :- !.

flora_nowsp(FL_CUT,0) :- !.
