/* File:      flrprint.P
**
** Author(s): Guizhen Yang
**
** Contact:   flora-users@lists.sourceforge.net
**
** Copyright (C) The Research Foundation of SUNY, 1999-2001
** 
** FLORA-2 is free software; you can redistribute it and/or modify it under the
** terms of the GNU Library General Public License as published by the Free
** Software Foundation; either version 2 of the License, or (at your option)
** any later version.
** 
** FLORA-2 is distributed in the hope that it will be useful, but WITHOUT ANY
** WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
** FOR A PARTICULAR PURPOSE.  See the GNU Library General Public License for
** more details.
** 
** You should have received a copy of the GNU Library General Public License
** along with FLORA-2; if not, write to the Free Software Foundation,
** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
**
*/


:- compiler_options([xpp_on]).

#include "standard.h"

:- dynamic
	flora_err_stream(_), flora_warn_stream(_),
	flora_msg_stream(_), flora_fdbk_stream(_).

?- (flora_err_stream(Stream) -> close(Stream), retractall(flora_err_stream(_))
   ; ioport2iostream(STDERR,Stream), assert(flora_err_stream(Stream))
   ).
?- (flora_warn_stream(Stream) -> close(Stream), retractall(flora_warn_stream(_))
   ; ioport2iostream(STDWARN,Stream), assert(flora_warn_stream(Stream))
   ).
?- (flora_msg_stream(Stream) -> close(Stream), retractall(flora_msg_stream(_))
   ; ioport2iostream(STDMSG,Stream), assert(flora_msg_stream(Stream))
   ).
?- (flora_fdbk_stream(Stream) -> close(Stream), retractall(flora_fdbk_stream(_))
   ; ioport2iostream(STDFDBK,Stream), assert(flora_fdbk_stream(Stream))
   ).

/*************************************************************************
  print utilities
*************************************************************************/
flora_stderr_nl :- flora_err_stream(Stream), nl(Stream).
%% Use format/3 so that we would be able to put formatting, like ~n in the Str
flora_stderr_string(Str) :- flora_err_stream(Stream), format(Stream,Str,_).
flora_stderr_string(Fmt,Args) :-
	flora_err_stream(Stream),
	format(Stream,Fmt,Args).


flora_stdwarn_nl :- flora_warn_stream(Stream), nl(Stream).
flora_stdwarn_string(Str) :- flora_warn_stream(Stream), format(Stream,Str,_).
flora_stdwarn_string(Fmt,Args) :- 
	flora_warn_stream(Stream),
	format(Stream,Fmt,Args).


flora_stdmsg_nl :- flora_msg_stream(Stream), nl(Stream).
flora_stdmsg_string(Str) :- flora_msg_stream(Stream), format(Stream,Str,_).
flora_stdmsg_string(Fmt,Args) :- 
	flora_msg_stream(Stream),
	format(Stream,Fmt,Args).
flora_stdmsg_line(M) :-
	flora_msg_stream(Stream),
	format(Stream,M,_),
	nl(Stream).


flora_stdfdbk_nl :- flora_fdbk_stream(Stream), nl(Stream).
flora_stdfdbk_string(Str) :- flora_fdbk_stream(Stream), format(Stream,Str,_).
flora_stdfdbk_string(Fmt,Args) :- 
	flora_fdbk_stream(Stream),
	format(Stream,Fmt,Args).
flora_stdfdbk_line(M) :-
	flora_fdbk_stream(Stream),
	format(Stream,M,_),
	nl(Stream).


flora_error_heading :- flora_stderr_string("++Error[FLORA]> ").
flora_error_indentline :- flora_stderr_string("               ").


flora_warning_heading :- flora_stdwarn_string("++Warning[FLORA]> ").
flora_warning_indentline :- flora_stdwarn_string("                 ").


flora_message_heading :- flora_stdmsg_string("[FLORA: ").
flora_message_tailing :- flora_stdmsg_line("]").


flora_error_line(Str) :-
	flora_error_heading,
	flora_stderr_string(Str),
	flora_stderr_nl.

flora_error_line(Fmt,Args) :-
	flora_error_heading,
	flora_stderr_string(Fmt,Args),
	flora_stderr_nl.

flora_warning_line(Str) :-
	flora_warning_heading,
	flora_stdwarn_string(Str),
	flora_stdwarn_nl.

flora_warning_line(Fmt,Args) :-
	flora_warning_heading,
	flora_stdwarn_string(Fmt,Args),
	flora_stdwarn_nl.

flora_message_line(Str) :-
	flora_message_heading,
	flora_stdmsg_string(Str),
	flora_message_tailing.

flora_message_line(Fmt,Args) :-
	flora_message_heading,
	flora_stdmsg_string(Fmt,Args),
	flora_message_tailing.

