/* File:      flrprolog.P -- Flora Prolog definitions
**
** Author(s): Guizhen Yang
**
** Contact:   flora-users@lists.sourceforge.net
**
** Copyright (C) The Research Foundation of SUNY, 1999-2001
**
** FLORA-2 is free software; you can redistribute it and/or modify it under the
** terms of the GNU Library General Public License as published by the Free
** Software Foundation; either version 2 of the License, or (at your option)
** any later version.
**
** FLORA-2 is distributed in the hope that it will be useful, but WITHOUT ANY
** WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
** FOR A PARTICULAR PURPOSE.  See the GNU Library General Public License for
** more details.
**
** You should have received a copy of the GNU Library General Public License
** along with FLORA-2; if not, write to the Free Software Foundation,
** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
**
*/


:- compiler_options([xpp_on]).

#include "flora_terms.flh"


/****************************************************************************
  Flora built-in operators
****************************************************************************/
flora_prlg(FL_IMPLYOP,2) :- !.
flora_prlg(FL_IMPLYOP,1) :- !.
flora_prlg(FL_QUERYOP,1) :- !.

flora_prlg(FL_UNIVEQ,2) :- !.
flora_prlg(FL_UNIVNOTEQ,2) :- !.
flora_prlg(FL_EQ,2) :- !.
flora_prlg(FL_NOTEQ,2) :- !.
flora_prlg(FL_ORDERLT,2) :- !.
flora_prlg(FL_ORDEREQLT,2) :- !.
flora_prlg(FL_ORDERGT,2) :- !.
flora_prlg(FL_ORDEREQGT,2) :- !.
flora_prlg(FL_IS,2) :- !.
flora_prlg(FL_MATHEQ,2) :- !.
flora_prlg(FL_MATHNOTEQ,2) :- !.
flora_prlg(FL_LT,2) :- !.
flora_prlg(FL_EQLT,2) :- !.
flora_prlg(FL_GT,2) :- !.
flora_prlg(FL_EQGT,2) :- !.
flora_prlg(FL_RIGHTTO,2) :- !.
flora_prlg(FL_LEFTTO,2) :- !.

flora_prlg(FL_COMMA,2) :- !.
flora_prlg(FL_SEMICOLON,2) :- !.

flora_prlg(FL_PLUS,2) :- !.
flora_prlg(FL_MINUS,2) :- !.
flora_prlg(FL_SYMOR,2) :- !.

flora_prlg(FL_FLOOR,1) :- !.
flora_prlg(FL_ABS,1) :- !.
flora_prlg(FL_FLOAT,1) :- !.

flora_prlg(FL_STAR,2) :- !.
flora_prlg(FL_SLASH,2) :- !.
flora_prlg(FL_MOD,2) :- !.
flora_prlg(FL_SYMAND,2) :- !.

flora_prlg(FL_PLUS,1) :- !.
flora_prlg(FL_MINUS,1) :- !.

flora_prlg(flora_abort,0) :- !.
flora_prlg(flora_abort,1) :- !.


/****************************************************************************
  XSB predicates that are also useful in FLORA
****************************************************************************/
flora_prlg(abolish_all_tables,0) :- !.
flora_prlg(call,1) :- !.
flora_prlg(compile,1) :- !.
flora_prlg(fail,0) :- !.
flora_prlg(findall,3) :- !.
flora_prlg(true,0) :- !.
flora_prlg(var,1) :- !.
flora_prlg(nonvar,1) :- !.
flora_prlg(atom,1) :- !.
flora_prlg(is_list,1) :- !.
flora_prlg(is_charlist,1) :- !.


/****************************************************************************
  FLORA shell commands and commands used to control FLORA from Prolog
****************************************************************************/
flora_prlg(flLoadedModule,1) :- !.
flora_prlg(flHelp,0) :- !.
flora_prlg(flReset,1) :- !.
flora_prlg(flAll,0) :- !.
flora_prlg(flOne,0) :- !.
flora_prlg(flEnd,0) :- !.
flora_prlg(flHalt,0) :- !.
flora_prlg(flMaxerr,1) :- !.
flora_prlg(flDemo,1) :- !.
flora_prlg(FL_COMPILE,1) :- !.
flora_prlg(FL_LOAD,1) :- !.
flora_prlg(FL_DUMP,1) :- !.
flora_prlg(flTrace,0) :- !.
flora_prlg(flTrace,1) :- !.
flora_prlg(flNoTrace,0) :- !.
flora_prlg(flTraceLow,0) :- !.
flora_prlg(flTraceLow,1) :- !.
flora_prlg(flNoTraceLow,0) :- !.
flora_prlg(flChatter,0) :- !.
flora_prlg(flNoChatter,0) :- !.


/****************************************************************************
  definition
****************************************************************************/
flora_prlgdef(X,Y) :-
	flora_prlg(X,Y),
	!.

flora_prlgdef(X,Y) :-
	(
	%%  flora_get_counter(flora_shell_mode,1) ->
	%%    flora_shprlg(X,Y)
	%%;
	  %% NOTE: flora_dynprlg exists only because of the way import
	  %% is handled in foo@prolog(mod). In this case, FLORA inserts
	  %% a dynamic declaration which tells that foo is a Prolog predicate.
	  flora_dynprlg(X,Y)
	).


/****************************************************************************
  flora_reset_prolog/0
****************************************************************************/
flora_reset_prolog :- retractall(flora_dynprlg(_,_)).


/****************************************************************************
  flora_define_prolog(+Op,+Arity)
****************************************************************************/
flora_define_prolog(Op,Arity) :-
	(var(Op); var(Arity)),
	!,
	assert(flora_dynprlg(Op,Arity)).

flora_define_prolog(Op,Arity) :-
	( flora_prlg(Op,Arity) ->
	    true
	;
	  assert(flora_dynprlg(Op,Arity))
	).


/****************************************************************************
  flora_shreset_prolog/0
****************************************************************************/
%%flora_shreset_prolog :- retractall(flora_shprlg(_,_)).


/****************************************************************************
  flora_shdefine_prolog(+Op,+Arity)
****************************************************************************/
%%flora_shdefine_prolog(Op,Arity) :-
%%	(var(Op); var(Arity)),
%%	!,
%%	assert(flora_shprlg(Op,Arity)).
%%
%%flora_shdefine_prolog(Op,Arity) :-
%%	( flora_prlg(Op,Arity) ->
%%	    true
%%	;
%%	  assert(flora_shprlg(Op,Arity))
%%	).
