/* File:      flrundefhook.P
**
** Author(s): Guizhen Yang
**            Michael Kifer
**
** Contact:   flora-users@lists.sourceforge.net
**
** Copyright (C) The Research Foundation of SUNY, 1999-2003
**
** FLORA-2 is free software; you can redistribute it and/or modify it under the
** terms of the GNU Library General Public License as published by the Free
** Software Foundation; either version 2 of the License, or (at your option)
** any later version.
** 
** FLORA-2 is distributed in the hope that it will be useful, but WITHOUT ANY
** WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
** FOR A PARTICULAR PURPOSE.  See the GNU Library General Public License for
** more details.
** 
** You should have received a copy of the GNU Library General Public License
** along with FLORA-2; if not, write to the Free Software Foundation,
** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
** 
** 
*/


:- compiler_options([xpp_on]).

#include "flora_terms.flh"


/****************************************************************************
  flora_undefined_predicate_hook/1
****************************************************************************/

%% Attempt to call a HiLog term as a predicate
flora_undefined_predicate_hook(WRAP_HILOG,Arity,_PrologModule) :-
	!,
	RealArity is Arity - 1,
	flora_error_line('Attempt to call a HiLog term of arity ~w as a predicate', [RealArity]).

%% A call to a molecule
flora_undefined_predicate_hook(PredName,Arity,PrologModule) :-
	%% Decode the predicate symbol.
	functor(PCall,PredName,Arity),
	flora_decode_predicate(PCall,PredicateType,ModuleName,_,PredicateSymbol,_),
	( PredicateType == (flogic) ->
	    %% an F-logic predicate
	    ( flLoadedModule(ModuleName) ->
		%% This is very unlikely to happen unless something goes wrong.
		flora_error_line('Attempt to call undefined F-logic molecule `~w'' in FLORA module `~w''',
			         [PredicateSymbol,ModuleName])
	    ;
	        flora_error_line('Attempt to call an F-logic molecule in an unloaded FLORA module `~w''',
                                 [ModuleName])
	    )

	; PredicateType == (hilog) ->
	    %% a HiLog predicate
	    RealArity is Arity - 1,
	    ( flLoadedModule(ModuleName) ->
		flora_error_line('Attempt to call undefined HiLog predicate of arity ~w in FLORA module `~w''',
				 [RealArity,ModuleName])
	    ;
	      flora_error_line('Attempt to call a HiLog predicate of arity ~w in an unloaded FLORA module `~w''',
                               [RealArity,ModuleName])
	    )
	; PredicateType == (prolog) ->
	    flora_error_line('Attempt to call undefined Prolog predicate ~w/~w in module `~w''',
                               [PredName,Arity,PrologModule])

	).
