/* File:      flraggsum.P
**
** Author(s): Guizhen Yang 
**
** Contact:   flora-users@lists.sourceforge.net
**
** Copyright (C) The Research Foundation of SUNY, 1999-2001
**
** FLORA-2 is free software; you can redistribute it and/or modify it under the
** terms of the GNU Library General Public License as published by the Free
** Software Foundation; either version 2 of the License, or (at your option)
** any later version.
** 
** FLORA-2 is distributed in the hope that it will be useful, but WITHOUT ANY
** WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
** FOR A PARTICULAR PURPOSE.  See the GNU Library General Public License for
** more details.
** 
** You should have received a copy of the GNU Library General Public License
** along with FLORA-2; if not, write to the Free Software Foundation,
** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
** 
** $Id: flraggsum.P,v 1.8 2003/06/18 07:01:21 kifer Exp $
** 
*/


:- compiler_options([xpp_on]).

#include "flora_terms.flh"

:- import ground/1, member/2 from basics.

:- import flora_warning_line/1 from flrprint.



/*********************************************************************
  fllibsum(+Var,+VarList,+Goal,-Sum)
*********************************************************************/
fllibsum(Var,[],Goal,Sum) :-
	!,
	findall(Var,Goal,Matches),
	flora_sumaux(Matches,Sum).

fllibsum(Var,VarList,Goal,Sum) :-
	ground(VarList),
	!,
	findall(Var,Goal,Matches),
	flora_sumaux(Matches,Sum).

fllibsum(Var,VarList,Goal,Sum) :-
	!,
	findall(flora_result(Var,VarList),Goal,Matches),
	findall(Grp,member(flora_result(_,Grp),Matches),GL),
	sort(GL,Groups),
	member(VarList,Groups),
	findall(D,member(flora_result(D,VarList),Matches),DL),
	flora_sumaux(DL,Sum).


/********************************************************************
  flora_sumaux(+List,-Sum).
  flora_sumaux(+List,-CurrSum,-Sum,-Warning)
********************************************************************/
flora_sumaux(Matches,Sum) :-
	flora_sumaux(Matches,_,Sum,Warning),
	( var(Warning) ->
	    true
	;
	  flora_warning_line("discarding non-numeric objects while computing sum")
	).


flora_sumaux([],X,Sum,_) :-
	!,
	(var(X) -> fail; Sum=X).

flora_sumaux([H|L],X,Sum,Warning) :-
	( number(H) ->
	    (var(X) -> S=H; S is X+H),
	    flora_sumaux(L,S,Sum,Warning)
	  ;
	    Warning=[],
	    flora_sumaux(L,X,Sum,_)
	).
