/* File:        flrdisplay.P
**
** Author(s): Guizhen Yang
**
** Contact:   flora-users@lists.sourceforge.net
**
** Copyright (C) The Research Foundation of SUNY, 1999-2001
**
** FLORA-2 is free software; you can redistribute it and/or modify it under the
** terms of the GNU Library General Public License as published by the Free
** Software Foundation; either version 2 of the License, or (at your option)
** any later version.
** 
** FLORA-2 is distributed in the hope that it will be useful, but WITHOUT ANY
** WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
** FOR A PARTICULAR PURPOSE.  See the GNU Library General Public License for
** more details.
** 
** You should have received a copy of the GNU Library General Public License
** along with FLORA-2; if not, write to the Free Software Foundation,
** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
** 
** $Id: flrdisplay.P,v 1.10 2003/06/18 07:01:20 kifer Exp $
** 
*/


:- compiler_options([xpp_on]).

#include "flora_terms.flh"
#include "standard.h"


:- import flora_err_stream/1, flora_fdbk_stream/1 from flrprint.
:- import flora_write_oid/2 from flrdecode.

:- export
	flora_display_error/1,
	flora_display_feedback/1,
	flora_write_string/2.


/********************************************************************/
%% These two are called to display errors/results,
%% which are Flora literals, in human-readable form
flora_display_error(InTerm) :-
	flora_err_stream(Stream),
	!,
	flora_write_oid(Stream,InTerm).

flora_display_feedback(InTerm) :-
	flora_fdbk_stream(Stream),
	!,
	flora_write_oid(Stream,InTerm).

