/* File:      flrequality.P
**
** Author(s): Guizhen Yang 
**
** Contact:   flora-users@lists.sourceforge.net
**
** Copyright (C) The Research Foundation of SUNY, 1999-2001
**
** FLORA-2 is free software; you can redistribute it and/or modify it under the
** terms of the GNU Library General Public License as published by the Free
** Software Foundation; either version 2 of the License, or (at your option)
** any later version.
** 
** FLORA-2 is distributed in the hope that it will be useful, but WITHOUT ANY
** WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
** FOR A PARTICULAR PURPOSE.  See the GNU Library General Public License for
** more details.
** 
** You should have received a copy of the GNU Library General Public License
** along with FLORA-2; if not, write to the Free Software Foundation,
** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
** 
** 
*/


:- compiler_options([xpp_on]).

#include "flora_terms.flh"
#include "flora_exceptions.flh"


:- import flloadtrailer/1, flloadtrailer/2 from flrutils.
:- import flora_trailer_registry/1 from flrregistry.

:- import flora_abort/0 from flrutils.




/*****************************************************************************
  fllibequality
*****************************************************************************/
fllibequality(A) :-
	( flloadtrailer(A) ->
		(flora_trailer_registry(FLORA_DEFAULT_WORKSPACE),!;
		assert(flora_trailer_registry(FLORA_DEFAULT_WORKSPACE)))
	;
		flora_abort
	).
fllibequality(A,M) :-
	( flloadtrailer(A,M) ->
		(flora_trailer_registry(M),!;assert(flora_trailer_registry(M)))
	;
		flora_abort
	).
