/* File:      flrimport.P - implementation of flImport, Prolog/Flora interface
**
** Author(s): kifer
**
** Contact:   flora-users@lists.sourceforge.net
**
** Copyright (C) The Research Foundation of SUNY, 1999-2001
** 
** FLORA-2 is free software; you can redistribute it and/or modify it under the
** terms of the GNU Library General Public License as published by the Free
** Software Foundation; either version 2 of the License, or (at your option)
** any later version.
** 
** FLORA-2 is distributed in the hope that it will be useful, but WITHOUT ANY
** WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
** FOR A PARTICULAR PURPOSE.  See the GNU Library General Public License for
** more details.
** 
** You should have received a copy of the GNU Library General Public License
** along with FLORA-2; if not, write to the Free Software Foundation,
** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
** $Id: flrimport.P,v 1.15 2003/06/18 07:01:19 kifer Exp $
**
*/

:- compiler_options([xpp_on]).

#include "flora_terms.flh"

check_args(P,A,Module) :-
	(atom(Module),!
	; flora_error_line('flImport: Module must be an atom'),
	  abort
	),
	%% check that P is given as foo/arity
	(functor(P,'/',_) -> true
	; flora_error_line('flImport: ~w Arg 1 must have the form Pred/Arity',
			   [P]),
	    %% don't use flora_abort here because this predicate can be
	    %% called from pure prolog where this exception is not caught.
	    %% It is also more correct to report this as a Prolog abort than
	    %% Flora abort.
	    abort
	),
	%% check that A is given as bar(_,_,_) and not as bar/Arity
	(functor(A,'/',_)
	-> flora_error_line('flImport: ~w Arg 2 must have the form Pred(_,_,...)',
			    [A]),
	    abort
	%% check if A and P have the same arity
	; functor(A,_,Arity), P=_/Arity -> true
	; flora_error_line('flImport: ~w and ~w must have the same arity',
			   [P,A]),
	    abort
	).

%% Clone A in the same module. Return a cloned A and the list of its arguments
duplicate(A,NewA,Args) :-
	copy_term(A,NewA),
	(dynamic NewA),
	NewA =.. [_|Args].

%% assert the connecting rule and load file into module, 
%% if file is not a variable
funish_up(NewA,NewP,File,Module) :-
	assert((NewA :- NewP)), % assert(A :- P).
	(var(File),!
	; flora_load_module_internal(File,Module),!	% load the module
	; abort
	).

%% The following two predicate do the following:
%% Get P in the form foo/Arity and A of the form bar(_,_,_,...)
%% of the same arity and assert
%%         bar(X,Y,Z) :- PREFIXfoo(X,Y,Z).
%% for the right arity, where PREFIX is the appropriate Flora prefix for Module
%% Make bar(...) dynamic and place it
%% into the correct XSB module (the module where flImport is called)
%% Use:
%%        :- flImport P as A from File>>Module.


%% This assumes that P is a prolog predicate within a flora program.
flImportPredicate(P,A,File,Module) :-
	check_args(P,A,Module),
	P = FuncP/ArityP,
	%% attach the workspace
	flora_hilog_module_predicate_symbol(Module,FloraHiLogWrap),
	ArityP1 is ArityP + 1,
	functor(NewP,FloraHiLogWrap,ArityP1),
	arg(1,NewP,FuncP),
	duplicate(A,NewA,Args),
	(import FloraHiLogWrap/ArityP1 from usermod), % import Flora Hilog pred
	%% unify the args of P and A.
	%% In HiLog the first arg is the predicate name, which is why _,_
	NewP =.. [_,_|Args],
	funish_up(NewA,NewP,File,Module).


