/* File:      flrmetaops.P
**
** Author(s): kifer
**
** Contact:   flora-users@lists.sourceforge.net
**
** Copyright (C) The Research Foundation of SUNY, 2001
**
** FLORA-2 is free software; you can redistribute it and/or modify it under the
** terms of the GNU Library General Public License as published by the Free
** Software Foundation; either version 2 of the License, or (at your option)
** any later version.
** 
** FLORA-2 is distributed in the hope that it will be useful, but WITHOUT ANY
** WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
** FOR A PARTICULAR PURPOSE.  See the GNU Library General Public License for
** more details.
** 
** You should have received a copy of the GNU Library General Public License
** along with FLORA-2; if not, write to the Free Software Foundation,
** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
** 
** $Id: flrmetaops.P,v 1.12 2003/06/18 07:01:19 kifer Exp $
** 
*/


:- compiler_options([xpp_on]).

:- import flora_module_predicate/4 from flrwrapper.

:- import
	get_canonical_form/2,
	convert_to_body_literal/2
    from flrcanon.

#include "flora_terms.flh"

/******************************************************************************
  FLLIBUNIVEQFORM(?X,?Y)
  The meta predicate ~
******************************************************************************/
FLLIBUNIVEQFORM(X,Y) :-
	(var(X) ; var(Y)),
	!,
	X=Y.

FLLIBUNIVEQFORM((X,XX),(Y,YY)) :-
	FLLIBUNIVEQFORM(X,Y),
	FLLIBUNIVEQFORM(XX,YY).

FLLIBUNIVEQFORM((X,XX),FLLIBMODLIT(FL_LIBMOD,(Y,YY),M)) :-
	FLLIBUNIVEQFORM(X,FLLIBMODLIT(FL_LIBMOD,Y,M)),
	FLLIBUNIVEQFORM(XX,FLLIBMODLIT(FL_LIBMOD,YY,M)).

FLLIBUNIVEQFORM(FLLIBMODLIT(FL_LIBMOD,(X,XX),M), (Y,YY)) :-
	FLLIBUNIVEQFORM(FLLIBMODLIT(FL_LIBMOD,X,M),Y),
	FLLIBUNIVEQFORM(FLLIBMODLIT(FL_LIBMOD,XX,M),YY).

FLLIBUNIVEQFORM((X;XX),(Y;YY)) :-
	FLLIBUNIVEQFORM(X,Y),
	FLLIBUNIVEQFORM(XX,YY).

FLLIBUNIVEQFORM((X;XX),FLLIBMODLIT(FL_LIBMOD,(Y;YY),M)) :-
	FLLIBUNIVEQFORM(X,FLLIBMODLIT(FL_LIBMOD,Y,M)),
	FLLIBUNIVEQFORM(XX,FLLIBMODLIT(FL_LIBMOD,YY,M)).

FLLIBUNIVEQFORM(FLLIBMODLIT(FL_LIBMOD,(X;XX),M), (Y;YY)) :-
	FLLIBUNIVEQFORM(FLLIBMODLIT(FL_LIBMOD,X,M),Y),
	FLLIBUNIVEQFORM(FLLIBMODLIT(FL_LIBMOD,XX,M),YY).

%% Now neither X nor Y are variables

%% Speed up the case of  nonvar1@Var1 ~ nonvar2@Var2
FLLIBUNIVEQFORM(FLLIBMODLIT(WrapX,X,MX),FLLIBMODLIT(WrapY,Y,MY)) :-
	WrapX \== FL_LIBMOD,
	WrapY \== FL_LIBMOD,
	WrapX = WrapY,
	X=Y,
	MX=MY.

%% Spped up the case of nonvar1@nonvarmod1 ~ nonvar2@nonvarmod2
FLLIBUNIVEQFORM(X,Y) :-
	X \= FLLIBMODLIT(_,_,_),
	Y \= FLLIBMODLIT(_,_,_),
	!,
	X=Y.

%% Common (expensive) case
FLLIBUNIVEQFORM(X,Y) :-
	get_canonical_form(X,(Wrap,Args,Mod,Callable1)),
	convert_to_body_literal(Callable1,Callable),
	get_canonical_form(Y,(_Wrap2,Args,Mod,Callable2)),
	convert_to_body_literal(Callable2,Callable),
	(var(Callable),nonvar(Wrap),nonvar(Args),nonvar(Mod)
	-> flora_module_predicate(Wrap,Args,Mod,Callable)
	;  var(Callable), nonvar(Wrap), nonvar(Args)
	%% Cases like a(X)@M ~ Y@Z where module stays unbound
	-> Callable = FLLIBMODLIT(Wrap,Args,Mod)
	;  true
	).


/******************************************************************************
  FLLIBMETAUNIV(?X,?Y)
  The meta predicate =..
******************************************************************************/

FLLIBMETAUNIV(X,Y) :- X =.. Y.
