/* File:      flrshdirect.P
**
** Author(s): Guizhen Yang 
**
** Contact:   flora-users@lists.sourceforge.net
**
** Copyright (C) The Research Foundation of SUNY, 1999-2001
**
** FLORA-2 is free software; you can redistribute it and/or modify it under the
** terms of the GNU Library General Public License as published by the Free
** Software Foundation; either version 2 of the License, or (at your option)
** any later version.
** 
** FLORA-2 is distributed in the hope that it will be useful, but WITHOUT ANY
** WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
** FOR A PARTICULAR PURPOSE.  See the GNU Library General Public License for
** more details.
** 
** You should have received a copy of the GNU Library General Public License
** along with FLORA-2; if not, write to the Free Software Foundation,
** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
** 
** 
*/


:- compiler_options([xpp_on]).

#include "flora_terms.flh"
#include "flora_exceptions.flh"



:- import flora_shdefine_hilogtable/3 from flrhilogtable.

:- import flora_shdefine_operator/3 from flroperator.

:- import flora_shdefine_arguments/3 from flrarguments.

:- import flora_storage_check_module_name/1 from flrstorageutils.

:- import
	flora_dyna_hilog_user_module_predicate_symbol/2,
	flora_dynz_hilog_user_module_predicate_symbol/2
   from flrwrapper.

:- import flora_abort/1 from flrutils.


/*****************************************************************************
  fllibshdirect

  Processes directives in the flora shell (like table, op, etc.)
*****************************************************************************/
%%fllibshdirect(FL_PROLOG,Funct,Arity) :-
%%	flora_shdefine_prolog(Funct,Arity).

fllibshdirect(FL_TABLE,Module,Funct,Arity) :-
	flora_shdefine_hilogtable(Module,Funct,Arity).

%% Executable version of this directive makes sense only in main
%% module in the shell
fllibshdirect(FL_OP,Module,Preced,Assoc,Op) :-
	(Module == FLORA_DEFAULT_WORKSPACE ->
	    flora_shdefine_operator(Preced,Assoc,Op)
	; true
	).

%% Executable version of this directive makes sense only in main
%% module in the shell
/** DEPRECATED
fllibshdirect(FL_ARGUMENTS,Module,Funct,Arity,Args) :-
	(Module == FLORA_DEFAULT_WORKSPACE ->
	    flora_shdefine_arguments(Funct,Arity,Args)
	; true
	).
**/

fllibshdirect(FL_INDEX,Module,Arity,Position) :-
	flora_storage_check_module_name(Module),
	( integer(Arity), integer(Position), Position>0, Arity >= Position ->
	    A is Arity+1,
            P is Position+1,
            flora_dyna_hilog_user_module_predicate_symbol(Module,NewPA),
            flora_dynz_hilog_user_module_predicate_symbol(Module,NewPZ),
            call(index(NewPA/A,P)),
            call(index(NewPZ/A,P))
	;
	    flora_abort("Invalid argument in index directive")
	).
