/* File:      plmchconfig.P -- loader for the xsbpattern foreign module
** Author(s): kifer
** Contact:   xsb-contact@cs.sunysb.edu
** 
** Copyright (C) The Research Foundation of SUNY, 1986, 1993-1998
** 
** XSB is free software; you can redistribute it and/or modify it under the
** terms of the GNU Library General Public License as published by the Free
** Software Foundation; either version 2 of the License, or (at your option)
** any later version.
** 
** XSB is distributed in the hope that it will be useful, but WITHOUT ANY
** WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
** FOR A PARTICULAR PURPOSE.  See the GNU Library General Public License for
** more details.
** 
** You should have received a copy of the GNU Library General Public License
** along with XSB; if not, write to the Free Software Foundation,
** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
** $Id: plmchconfig.P,v 1.15 2002/07/12 04:56:49 kifer Exp $
** 
*/

:- compiler_options([xpp_on]).
#include "extensions_xsb.h"



:- import slash/1, str_cat/3, machine_file_exists/1 from machine.
:- import fmt_write_string/3, file_time/2 from file_io.
:- import search_module/6 from consult.
:- import xsb_configuration/2 from xsb_configuration.
:- import runtime_loader_flag/3 from foreign.
:- import rename/2 from shell.

%% Construct the file cc/xsbpattern.H on the fly
make_xsbpatternH(CC, CC_opts) :-
   slash(Slash),
    xsb_configuration(perl_archlib, PerlArchlib),
    xsb_configuration(perl_libs, Libs),
    xsb_configuration(compiler, XCC),
    xsb_configuration(configuration, XSBconfiguration),
    fmt_write_string(PerlCORE, '%s%sCORE', f(PerlArchlib,Slash)),
    runtime_loader_flag(CC, PerlCORE, RunpathFlag),
    fmt_write_string(LD_flags,
		     ' %s -L%s -lperl %s',
		     f(RunpathFlag, PerlCORE, Libs)),
    package_configuration(dir(perlmatch), PerlmatchDir),
    fmt_write_string(LD_directives_file,
		     '%s%scc%sxsbpattern.H', f(PerlmatchDir, Slash, Slash)),
    telling(OldTell),
    tell(LD_directives_file),
    writeln('%% This file is generated on-the-fly by plmchconfig.P'),
    writeln('%% Do not edit--any changes will be written over.'),
    write('%% XSB config:    '), writeln(XSBconfiguration),
    write('%% XSB CC:        '), writeln(XCC),
    write('%% Perl CC:       '), writeln(CC),
    write('%% Perl CC Opts: '), writeln(CC_opts),
    writeln(':- import slash/1 from machine.'),
    writeln(':- export try_match__/2, next_match__/0, do_bulk_match__/3, load_perl__/0, unload_perl__/0, get_match_resultC__/2, perl_substitute__/3, get_bulk_match_result__/3.'),
    write(':- ldoption('''),
    write(LD_flags),
    writeln(''').'),
    told,
    tell(OldTell).
    

:-  package_configuration(dir(perlmatch), PerlmatchDir),
    slash(Slash),
    Basename = xsbpattern,
    fmt_write_string(Module,
		     '%s%scc%s%s', f(PerlmatchDir, Slash, Slash,Basename)),
    (  %% avoid recompilation: check if xsbpattern object file exists and 
       %% is newer than xsbpattern.c.
       search_module(Basename,Dir,_Mod,_Ext,_Base,ModuleO),
       str_cat(Module, '.c', ModuleSourceFile),
       str_cat(Module, XSB_HDR_EXTENSION_ATOM, ModuleH),
       machine_file_exists(ModuleH),
       file_time(ModuleO, time(CT1,CT2)),
       file_time(ModuleSourceFile, time(ST1,ST2)),
       time(ST1,ST2) @< time(CT1,CT2)
	       %% module compiled and is current, so just load
	       -> [Basename]

    %% Module isn't compiled or is old, so recompile
    ;   xsb_configuration(perl_cc_compiler, CC),
	xsb_configuration(perl_archlib, PerlArchlib),
	xsb_configuration(perl_ccflags, CCflags),
	fmt_write_string(CC_opts,
			 ' %s -I%s%sCORE ',
			 f(CCflags,PerlArchlib,Slash)),
	make_xsbpatternH(CC, CC_opts),
	xsb_configuration(config_libdir, ConfigLibdir),
	str_cat(Module, XSB_OBJ_EXTENSION_ATOM, Objfile),
	consult(Module, [cc(CC), cc_opts(CC_opts)]),
	fmt_write_string(LibObjFile,
			 '%s%s%s%s',
			 args(ConfigLibdir,Slash,Basename,XSB_OBJ_EXTENSION_ATOM)),
	rename(Objfile, LibObjFile),
	%% Note: the .so ending is heavily Unix-centered. I dunno what this
	%% corresponds to in windows. - mk
	str_cat(Module, '.so', SharedLib),
	fmt_write_string(LibMod, '%s%s%s.so', a(ConfigLibdir,Slash,Basename)),
	rename(SharedLib,LibMod)
     ).
