/* File:      script.P
** Author(s): 
** Contact:   lmc@cs.sunysb.edu
** 
** Copyright (C) SUNY at Stony Brook, 1998-2000
** 
** XMC is free software; you can redistribute it and/or modify it under the
** terms of the GNU Library General Public License as published by the Free
** Software Foundation; either version 2 of the License, or (at your option)
** any later version.
** 
** XMC is distributed in the hope that it will be useful, but WITHOUT ANY
** WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
** FOR A PARTICULAR PURPOSE.  See the GNU Library General Public License for
** more details.
** 
** You should have received a copy of the GNU Library General Public License
** along with XMC; if not, write to the Free Software Foundation,
** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
** $Id: script.P,v 1.2 2001/07/01 21:52:54 gmkp Exp $
** 
*/

:- consult(mucalculus, [spec_off]).
:- [navigate].
:- [reader].
:- [justify].
%:- [just_linear].
:- import length/2 from basics.

run(SpecFile, Sys, Form, Root) :-
	cleanup, 
	load_dyn(SpecFile),
	load_dyn('formula'),
	load_dyn('annot.P'),
	program_read('mucalculus.P'),
	program_read(SpecFile), 
	program_read('formula'), !,
	query(mck(Sys, Form), Root).

run(SpecFile, Init, Sys, Form,  Root) :-
	cleanup, 
	load_dyn(SpecFile),
	load_dyn('formula'),
	load_dyn('annot.P'),
	program_read('mucalculus.P'),
	program_read(SpecFile), 
	program_read('formula'), !,
	call(Init), query(mck(Sys, Form), Root).


cleanup :- 
	retractall(allowed(_)),
	retractall(leaf(_)),
	retractall(rule(_,_)),
	retractall(tabled_pred(_)),
	retractall(node(_,_,_)),
	retractall(arc(_,_)),
	retractall(rootnode(_)),
	retractall(node_equiv(_,_)),
	abolish_all_tables.

%--------------------------------------------------------------------------
root((X, Y, Z)) :- rootnode(X), node(X, Y, Z).
child(X, (C, G, T)) :- arc(X, C), node(C, G, T).

states(N) :- findall(S, completed(models(S, _), _), L), 
	     rem_dup(L, L1), length(L1, N).

st(N) :- findall(S, called(models(S, _)), L), 
	 rem_dup(L, L1), length(L1, N).


rem_dup(L, L1) :- remove_dupl(L, [], L1).

remove_dupl([], X, X).
remove_dupl([H|T], X, Res) :-
	 ( member(H, X) -> remove_dupl(T, X, Res)
                        ;  remove_dupl(T, [H|X], Res)
         ).

%------------------------------------------------------------

