:- assert(xmc_directory('/home/stufs1/giri/projects/t/xmc/System')).
/* File:      xmc.P	-- main textual interface for XMC
** Author(s): C.R. Ramakrishnan, Yifei Dong
** Contact:   lmc@cs.sunysb.edu
** 
** Copyright (C) SUNY at Stony Brook, 1998-2000
** 
** XMC is free software; you can redistribute it and/or modify it under the
** terms of the GNU Library General Public License as published by the Free
** Software Foundation; either version 2 of the License, or (at your option)
** any later version.
** 
** XMC is distributed in the hope that it will be useful, but WITHOUT ANY
** WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
** FOR A PARTICULAR PURPOSE.  See the GNU Library General Public License for
** more details.
** 
** You should have received a copy of the GNU Library General Public License
** along with XMC; if not, write to the Free Software Foundation,
** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
** $Id: xmc.P,v 1.2 2001/07/01 21:52:54 gmkp Exp $
** 
*/

%% ----------------------------------------------------------------------
%%	xlc(S): compile XL program to trans rules.
%% ----------------------------------------------------------------------

:- assert((library_directory(D) :- xmc_directory(D))).

:- [mucalculus].

xlc(File) :-
	cleanup,
	str_cat(File, '.xl', XLFile),
	str_cat(XLFile, 'o', XLOFile),
	parse(XLFile, XLOFile, stderr),
	typecheck(XLOFile),
	comp_form,
	xlcomp.

cleanup :-
	retractall(trans(_,_,_)),
	retractall((trans(_,_,_) :- _)),
	retractall((trans(_,_,_,_,_) :- _)),
	retractall(startstate(_,_)),
	retractall(symlookup(_,_,_,_)),
	retractall(fDef(_,_)),
	abolish_all_tables.

%% ----------------------------------------------------------------------
%%	mck(P, F): Top level modelcheck predicate:
%%		   Does process named P model formula named F?
%% ----------------------------------------------------------------------

mck(P, F) :-
	start(P, S),
	models(S, form(F)).

