
:- compiler_options([xpp_on,ciao_directives]).

:- export atom_concat/2, atom_concat/3, 
	  (data)/1, display/2, 
	  error_message/1, error_message/2, 
	  fast_read/1, fast_write/1,
	  list_concat/2, 
	  note_message/1, optional_message/2,
	  pop_prolog_flag/1,  push_prolog_flag/1,
	  retract_fact/1, 
	  set_libs/1,
	  xsbdoc_error/1,
	  xsbdoc_warning/1.

:- import format/2 from format.
:- import concat_atom/2 from string.
:- import warning/1,messageln/2, message/2 from standard.
:- import member/2 from basics.

#include "flag_defs_xsb.h"
#include "standard.h"

% TLS: handle so I can set_libs.
set_libs([]).

data(_).

pop_prolog_flag(X):- warning((pop_prolog_flag(X),' is a no-op')).

push_prolog_flag(X):- warning((push_prolog_flag(X),' is a no-op')).

retract_fact(_):- retract(_).

retractall_fact(_):- retractall(_).

/* TLS: the following has a slightly different semantics from flatten */

:- pred dlist(List,DList,Tail) # "@var{List} is the result of removing
   @var{Tail} from the end of @var{DList} (makes a difference list from
   a list).".

dlist([], X, X).
dlist([X|Y], [X|L], T) :- dlist(Y, L, T).

:- pred list_concat(list(LL,list),list(L)) # "@var{L} is the
   concatenation of all the lists in @var{LL}.".

list_concat([],[]).
list_concat([L|RL],Head) :- 
	dlist(L,Head,Tail),
	list_concat(RL,Tail).

atom_concat(List,Atom):- concat_atom(List,Atom).

atom_concat(Atom1,Atom2,Atom3):- concat_atom([Atom1,Atom2],Atom3).

% TLS: perhaps this is not the way to do it, but ciao display/2 is a kernal 
% predicate.

display(Str,Term):- write(Str,Term).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Messages
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% TLS: waiting until we have Ports and Streams correlated in order to
% do more.

error_message(Format):-
	write('Error: '),
	format(Format,[]).

error_message(Format,Args):-
	write('Error: '),
	format(Format,Args).

note_message(Format):- 
	messageln(Format,STDMSG).

optional_message(Message,Opts):- 
	member('-v',Opts),!,
	writeln(Message).
optional_message(_Message,_Opts).

fast_read(Term):- read(Term).

fast_write(Term):- write(Term).
 

current_fact(Goal):- call(Goal).

undo_decls(Base) :-
        current_fact(undo_decl(Base, _, UndoGoal)),
          call(UndoGoal),
        fail.
undo_decls(_).

xsbdoc_warning(Message):- 
	message('++Warning[xsbdoc]: ', STDWARN),
	messageln(Message, STDWARN).

xsbdoc_error(Message):- 
	message('++Warning[xsbdoc]: ', STDERR),
	messageln(Message, STDERR).
