/* File:      banner.P -- API for controlling the banner
** Author(s): kifer
** Contact:   xsb-contact@cs.sunysb.edu
** 
** Copyright (C) The Research Foundation of SUNY, 2002
** 
** XSB is free software; you can redistribute it and/or modify it under the
** terms of the GNU Library General Public License as published by the Free
** Software Foundation; either version 2 of the License, or (at your option)
** any later version.
** 
** XSB is distributed in the hope that it will be useful, but WITHOUT ANY
** WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
** FOR A PARTICULAR PURPOSE.  See the GNU Library General Public License for
** more details.
** 
** You should have received a copy of the GNU Library General Public License
** along with XSB; if not, write to the Free Software Foundation,
** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
** $Id: banner.P,v 1.1 2002/09/20 06:00:02 kifer Exp $
** 
*/



:- compiler_options([xpp_on,sysmod,optimize]).

#include "sig_xsb.h"
#include "flag_defs_xsb.h"

:- export banner_control/1.
:- import stat_flag/2 from machine.

banner_control(noprompt) :-
	stat_flag(BANNER_CTL,BannerCtl),
	HidePrompt is BannerCtl mod NOPROMPT,
	HidePrompt =:= 0.
banner_control(nobanner) :-
	stat_flag(BANNER_CTL,BannerCtl),
	HideBanner is BannerCtl mod NOBANNER,
	HideBanner =:= 0.
banner_control(quietload) :-
	stat_flag(BANNER_CTL,BannerCtl),
	KeepQuiet is BannerCtl mod QUIETLOAD,
	KeepQuiet =:= 0.
