/* File:      machine.P
** Author(s): Jiyang Xu, Kostis Sagonas, Terrance Swift, David S. Warren,
**    	      Ernie Johnson 
** Contact:   xsb-contact@cs.sunysb.edu
** 
** Copyright (C) The Research Foundation of SUNY, 1986, 1993-1999
** Copyright (C) ECRC, Germany, 1990
** 
** XSB is free software; you can redistribute it and/or modify it under the
** terms of the GNU Library General Public License as published by the Free
** Software Foundation; either version 2 of the License, or (at your option)
** any later version.
** 
** XSB is distributed in the hope that it will be useful, but WITHOUT ANY
** WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
** FOR A PARTICULAR PURPOSE.  See the GNU Library General Public License for
** more details.
** 
** You should have received a copy of the GNU Library General Public License
** along with XSB; if not, write to the Free Software Foundation,
** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
** $Id: machine.P,v 1.60.2.1 2003/06/27 14:16:16 lfcastro Exp $
** 
*/

/*----------------------------------------------------------------------*/
/* NOTE: This file BETTER be always compiled with the "sysmod" option.	*/
/*----------------------------------------------------------------------*/

:- compiler_options([sysmod,xpp_on]).

#include "builtin.h"
#include "celltags_xsb.h"
#include "flag_defs_xsb.h"
#include "syscall_xsb.h"

/*======================================================================*/
/* This file contains definitions for predicates implemented by the	*/
/* underlying machine (hard builtins).	For those builtins that are     */
/* inlined by the compiler, a dummy definition of the form:             */
/*       pred(X1,...,Xn) :- pred(X1,...,Xn).                            */
/* appears below.  This way, the dependency between this file and       */
/* the emulator is minimized; also this gives a way of making sure that */
/* file cmplib/builtin.P stays up-to-date.  A side-effect of this is    */
/* that cmplib/builtin.P needs to be updated and compiled *BEFORE* this */
/* file.  Other builtins that are not inlined have a definition:        */
/*      pred(_X1,...,_Xn) :- '_$builtin'(BUILTIN_NAME).                 */
/* where BUILTIN_NAME is supposed to exist in emu/builtin.h.            */
/* We should make sure that we have as little as possible in the later  */
/* category by updating cmplib/builtin.P appropriately.  Currently, we  */
/* have more such definitions than needed, probably because builtin.P   */
/* needs an update.                                        - Kostis.    */
/*======================================================================*/

psc_name(PSC, String) :- psc_name(PSC, String).
psc_arity(PSC, Arity) :- psc_arity(PSC, Arity).
psc_type(PSC, Type) :- psc_type(PSC, Type).
psc_prop(PSC, Term) :- psc_prop(PSC, Term).
psc_set_type(PSC, Type) :- psc_set_type(PSC, Type).
psc_set_prop(PSC, Term) :- psc_set_prop(PSC, Term).
psc_set_spy(PSC, Spy) :- psc_set_spy(PSC, Spy).
psc_ep(PSC, Term) :- psc_ep(PSC, Term).
psc_set_ep(PSC, Term) :- psc_set_ep(PSC, Term).

term_psc(Term, PSC) :- term_psc(Term, PSC).
term_type(Term, Type) :- term_type(Term, Type).
term_compare(Term1, Term2, Res) :- term_compare(Term1, Term2, Res).
term_new(PSC, Term) :- term_new(PSC, Term).
term_arg(Term, Index, Arg) :- term_arg(Term, Index, Arg).
term_set_arg(Term, Index, Arg, Perm) :- term_set_arg(Term, Index, Arg, Perm).
stat_flag(Flag, Value) :- stat_flag(Flag, Value).
stat_set_flag(Flag, Value) :- stat_set_flag(Flag, Value).
buff_alloc(Size, Buffer) :- buff_alloc(Size, Buffer).
buff_word(Buffer, Disp, Value) :- buff_word(Buffer, Disp, Value).
buff_set_word(Buffer, Disp, Value) :- buff_set_word(Buffer, Disp, Value).
buff_byte(Buffer, Disp, Value) :- buff_byte(Buffer, Disp, Value).
buff_set_byte(Buffer, Disp, Value) :- buff_set_byte(Buffer, Disp, Value).
code_call(CodeAddr, Term, Type) :- code_call(CodeAddr, Term, Type).

substring(_String, _From, _To, _Result) :- '_$builtin'(SUBSTRING).
str_len(String, Length) :- str_len(String, Length).
str_cat(Str1, Str2, Str3) :- str_cat(Str1, Str2, Str3).
str_cmp(Str1, Str2, Res) :- str_cmp(Str1, Str2, Res).
string_substitute(_String, _SubstSpec, _SubstList, _Result) :-
	'_$builtin'(STRING_SUBSTITUTE).

call0(Term) :- call0(Term).
stat_sta(X) :- stat_sta(X).
stat_cputime(X) :- stat_cputime(X).
stat_walltime(X) :- stat_walltime(X).
code_load(ByteCodeFileName, InitAddr, Exp) :-
	code_load(ByteCodeFileName, InitAddr, Exp).
buff_set_var(Buff, Disp, BuffSize, Var) :-
	buff_set_var(Buff, Disp, BuffSize, Var).
buff_dealloc(Buff, OldSize, NewSize) :- buff_dealloc(Buff, OldSize, NewSize).
buff_cell(Buff, Disp, Cell) :- buff_cell(Buff, Disp, Cell).
buff_set_cell(Buff, Disp, Tag, Value) :- buff_set_cell(Buff, Disp, Tag, Value).

/* check if Sub is a substring in Str and return the matches.
   Also does matching from the end */
str_match(Sub,Str,Direction,Beg,End) :- str_match(Sub,Str,Direction,Beg,End).

/* If file is a directory, add slash, if needed, or strip extra slashes */
dirname_canonic(File, Canonic) :- dirname_canonic(File, Canonic).
/* for efficiency reasons, the following predicates are also implemented */
psc_insert(Name, Arity, PSC, MName) :- psc_insert(Name, Arity, PSC, MName).
psc_import(Pname, Arity, MName) :- psc_import(Pname, Arity, MName).

psc_insertmod(ModName, Def, PSC) :- psc_insertmod(ModName, Def, PSC).

file_gettoken(File, PrevCh, Type, Value, NextCh) :-
	file_gettoken(File, PrevCh, Type, Value, NextCh).
file_puttoken(File, Type, Value) :- file_puttoken(File, Type, Value).
term_hash(Term, Size, Value) :- term_hash(Term, Size, Value).
unload_seg(CodeSeg) :- unload_seg(CodeSeg).
load_obj(FileName, Mod, LdOption, InitAddr) :-
	load_obj(FileName, Mod, LdOption, InitAddr).

getenv(EnvVar, Value) :- getenv(EnvVar, Value).

sys_syscall(_CallNo, _Res, _A1, _A2) :- '_$builtin'(SYS_SYSCALL).
sys_system(CallNo, Command, _Arg1,_Arg2,_Arg3,_Arg4,_Arg5) :-
    sys_system(CallNo, Command, _Arg1,_Arg2,_Arg3,_Arg4,_Arg5).
sys_gethost(Name, Buffer) :- sys_gethost(Name, Buffer).
sys_errno(Errno) :- sys_errno(Errno).

file_stat(File, Which, RetVal) :- file_stat(File, Which, RetVal).
file_writequoted(File, Term) :- file_writequoted(File, Term).

intern_string(Str, InternedStr) :- intern_string(Str, InternedStr).
expand_filename(FileName, ExpandedFileName) :-
	expand_filename(FileName, ExpandedFileName).
tilde_expand_filename(FileName, ExpandedFileName) :-
	tilde_expand_filename(FileName, ExpandedFileName).
is_absolute_filename(FileName) :- is_absolute_filename(FileName).
parse_filename(FileName, Dir, Basename, Extension) :-
	parse_filename(FileName, Dir, Basename, Extension).
almost_search_module(FileName, Dir, ModName, Extension, BaseName) :-
	almost_search_module(FileName, Dir, ModName, Extension, BaseName).
existing_file_extension(FileName, Extension) :-
	existing_file_extension(FileName, Extension).

conget(_Term,_Val) :- '_$builtin'(CONGET_TERM).
conset(_Term,_Val) :- '_$builtin'(CONSET_TERM).

psc_env(PSC, Env) :- psc_env(PSC, Env).
psc_spy(PSC, Spy) :- psc_spy(PSC, Spy).
psc_tabled(PSC, Tabled) :- psc_tabled(PSC, Tabled).

is_xwammode(Flag) :- is_xwammode(Flag).
dereference_the_bucket(Pair_Pointer, Pair) :-
	dereference_the_bucket(Pair_Pointer, Pair).
pair_psc(Pair, PSC) :- pair_psc(Pair, PSC).
pair_next(Pair, Next_Pair) :- pair_next(Pair, Next_Pair).
next_bucket(Bucket, Next_Bucket) :- next_bucket(Bucket, Next_Bucket).

close_open_tables :- close_open_tables.

file_function(Function, A, B, C, D, E, F) :-
	file_function(Function, A, B, C, D, E, F).
slash(Slash) :- slash(Slash).

abolish_table_info :- abolish_table_info.
zero_out_profile :- '_$builtin'(ZERO_OUT_PROFILE).
write_out_profile :- '_$builtin'(WRITE_OUT_PROFILE).
assert_code_to_buff(Clause) :- assert_code_to_buff(Clause).
assert_buff_to_clref(Head, NAri, Prref, AZ, RInd, HashTabSize) :-
	assert_buff_to_clref(Head, NAri, Prref, AZ, RInd, HashTabSize).

file_read_canonical(_File,_Var,_Ret) :- '_$builtin'(FILE_READ_CANONICAL).
gen_retract_all(_Buff) :- '_$builtin'(GEN_RETRACT_ALL).

db_retract0(_Clause,_DontReclaim) :- '_$builtin'(DB_RETRACT0).
db_get_clause(_CC0,_CIL,_CI,_PrRef,_Head,_Failed,_Clause,_Type,_Entry,_NCIL,_NCI) :- 
	'_$builtin'(DB_GET_CLAUSE).
db_build_prref(_PSC,_Tabled,_PrRef) :- '_$builtin'(DB_BUILD_PRREF).
db_remove_prref(_Prref) :- '_$builtin'(DB_REMOVE_PRREF).
db_reclaim0(_Clause,_Type) :- '_$builtin'(DB_RECLAIM0).

formatted_io(_OPnumber, _FileOrString,_Format,_ArgTerm,_RetCode) :-
	'_$builtin'(FORMATTED_IO).

trimcore :- '_$builtin'(TRIMCORE).

put_attributes(_Var, _VNew) :- '_$builtin'(PUT_ATTRIBUTES).
get_attributes(_Var, _V, _OldMask) :- '_$builtin'(GET_ATTRIBUTES).
delete_attributes(_Var) :- '_$builtin'(DELETE_ATTRIBUTES).

'_$attv_unify'(_Var,_Value) :- '_$builtin'(ATTV_UNIFY).

is_attv(X) :- is_attv(X).

attv_unify(Var, Value) :-
	(   is_attv(Var)
	->  '_$attv_unify'(Var,Value)
	;   Var = Value
	).

/* This is the builtin where people should put their private, experimental
   builtin code. SEE THE EXAMPLE IN emu/private_builtin.c to UNDERSTAND HOW 
   TO DO IT. Note: even though this is a single builtin, YOU CAN SIMULATE 
   ANY NUMBER OF BUILTINS WITH IT. */
private_builtin(_OpCode,_A1,_A2,_A3,_A4,_A5,_A6,_A7,_A8,_A9,_A10) :-
	'_$builtin'(PRIVATE_BUILTIN).

segfault_handler(_Type) :- '_$builtin'(SEGFAULT_HANDLER).

is_charlist(_List, _Size) :- '_$builtin'(IS_CHARLIST).

oracle_query(_A, _B, _C, _D, _E, _F, _G) :- '_$builtin'(ORACLE_QUERY).
odbc_exec_query(_A, _B, _C, _D, _E, _F) :- '_$builtin'(ODBC_EXEC_QUERY).

'$$set_scope_marker':- '$$set_scope_marker'.
'$$unwind_stack':- '$$unwind_stack'.
'$$clean_up_block':- '$$clean_up_block'.

pow(_X,_Y,_Z):- '_$builtin'(XSB_POW).

print_ls :- print_ls.
print_tr :- print_tr.
print_heap(X,Y) :- print_heap(X,Y).
print_cp :- print_cp.
print_regs :- print_regs.
print_all_stacks :- print_all_stacks.
expand_heap :- expand_heap.
mark_heap(X) :- mark_heap(X).
gc_heap :- gc_heap.
'$$findall_init'(_I,_C) :- '$$findall_init'(_I,_C).
'$$findall_add'(_T,_I,_C) :- '$$findall_add'(_T,_I,_C).
'$$findall_get_solutions'(_L,_T,_I,_C) :-
        '$$findall_get_solutions'(_L,_T,_I,_C).

socket_request(_ReqNumber,_Domain,_Sockfd,_Port,_Hostname,_Sockfptr,_Error) :-
	'_$builtin'(SOCKET_REQUEST).

/*======================================================================*/

is_charlist(List) :- is_charlist(List, _).

conname(Con, Name) :-
	term_type(Con, Type),
	( Type =:= XSB_STRING -> Name = Con
	; Type =:= XSB_STRUCT -> term_psc(Con, Psc), psc_name(Psc, Name)
	).

conpsc(Con, Psc) :-
	term_type(Con, Type),
	( Type =:= XSB_STRUCT -> term_psc(Con, Psc)
	; Type =:= XSB_STRING -> psc_insert(Con, 0, Psc, 0)
	).

machine_file_exists(File) :- 
	sys_syscall(SYS_access, Res, File, 'r'), Res =:= 0.

/*======================================================================*/
/* Some other stuff for convenience here;                               */
/*======================================================================*/

set_pil_on :- stat_set_flag(PIL_TRACE,1).
set_pil_off :- stat_set_flag(PIL_TRACE,0).
set_prof_off :- stat_set_flag(PROFFLAG,0).
set_prof_on(Level) :- stat_set_flag(PROFFLAG,Level).

/* --------------------- end of file machine.P ------------------------ */
