%define name	Xdialog
%define version	2.1.2
%define release	1

Name:		%{name}
Summary:	Xdialog is a X11 drop in replacement for cdialog.
Version:	%{version}
Release:	%{release}
Source:		%{name}-%{version}.tar.bz2
Group:		X11/Administration
URL:		http://xdialog.dyns.net/
Copyright:	GPL
Packager:	Thierry Godefroy <xdialog@free.fr>
Prefix:		/usr
BuildRoot:	/var/tmp/%{name}-buildroot
BuildRequires:	gettext
Provides:	Xdialog

%description
Xdialog is designed to be a drop in replacement for the cdialog program.
It converts any terminal based program into a program with an X-windows
interface. The dialogs are easier to see and use and Xdialog adds even
more functionalities (help button+box, treeview, editbox, file selector,
range box, and much more).

%prep
rm -rf $RPM_BUILD_ROOT
%setup -q

%build
# CFLAGS="%optflags"
# ./configure
%configure
# Fix bugs in many automake versions:
RANLIBBIN=`which ranlib`
sed -e "s:RANLIB = @RANLIB@:RANLIB = $RANLIBBIN:" lib/Makefile > lib/Makefile.patched
mv -f lib/Makefile.patched lib/Makefile
XGETTEXTBIN=`which xgettext`
sed -e "s;XGETTEXT = :;XGETTEXT = $XGETTEXTBIN;" po/Makefile > po/Makefile.patched
mv -f po/Makefile.patched po/Makefile

make

%install
%makeinstall

%{find_lang} %{name}

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root,0755)
%doc samples doc/*.html doc/*.png
%_mandir/man1/Xdialog.1*
%_bindir/*
%{prefix}/share/locale/*/LC_MESSAGES/Xdialog.mo

%changelog
* Fri Jul 23 2004 Thierry Godefroy <xdialog@free.fr>
	v2.1.2  - Added the ESC keyboard shortcut for the CANCEL/NO button.
	        - Added the Indonesian, Dutch, Polish, Italian, Catalan and
                  Swedish translations.
                - Changed Xmessage and textbox samples for compatibility with
                  bash-less systems.
                - Updated for gettext v0.13.1.
                - Added fixes in the spec file for automake bugs.

* Wed Apr 02 2003 Thierry Godefroy <xdialog@free.fr>
	v2.1.1  - Fixed a bug in --calendar where an improper date (month) was
                  preset when a null parameter was passed.
                - Applied a patch to allow Xdialog to build outside the source
                  tree with VPATH.

* Tue Mar 25 2003 Thierry Godefroy <xdialog@free.fr>
	v2.1.0  - Adapted a patch allowing to pass optional <hours>, <minutes>
                  and <seconds> parameters to the --timebox.
                  Also made the <day>, <month> and <year> parameters of the
                  --calendar optional.
		- The --infobox and --gauge widgets now use non-blocking read()
		  calls instead of scanf() ones.
                - Implemented the new --colorsel and --fontsel widgets.
                - Added an optional <status> parameter to the --check option.
                - Fixed a bug which made Xdialog coredump when the first row of
                  a --menubox was set "unselectable" (NULL tag) and when the
                  "OK" button was pressed without selecting another row.
                - Fixed the charset for pt_BR.po and hu.po.
                - Applied a patch to avoid using a temporary file for printing
                  and using a pipe instead (safer, cleaner). Removed the
                  corresponding "--with-print-tmpfile" option from configure.in
                - New Makefile.am, doc/Makefile.am and configure.in. The doc
                  files are now built during the 'make all' instead of the
                  'make install' step. It should also fix the problems with
                  the bad paths to the Xdialog doc files appearing in the man
                  page on some systems.
                - Changed the URL for Xdialog website in sources and doc.
                - Documentation updates.

* Thu Apr 11 2002 Thierry Godefroy <xdialog@free.fr>
	v2.0.6	- Added the "Hide typing" check button into input boxes when
		  --password option is in use.
		- Corrected a bug where "unchecked" was not returned with
		  --check and --inputbox combination when the enter key was
		  pressed to close the box.
		- Norvegian translations added (courtessy of Jostein
		  Christoffer Andersen).

See the ChangeLog (or changelog.html) file for details about older changes...
