#ifndef __PLAYER_H
#define __PLAYER_H
#include <glib.h>
#define CAN_PLAY 1
#define CAN_PAUSE 2
#define CAN_FF 4
#define CAN_RW 8
#define CAN_NEXT 16
#define CAN_PREV 32
#define CAN_STOP 64
#define CAN_SEEK 128
#define CAN_LOOP 256
#define CAN_VOLUME 512
#define CAN_DOUBLE 1024
#define CAN_FULLSCREEN 2048
#define GIVES_RES 4096
#define GIVES_FRAME 8192
#define GIVES_FPS 16384
#define GIVES_POSITION 32768
#define GIVES_SETTINGS 65536
#define CAN_SUB 131072
#define GIVES_TIME 262144
/* Functions inherited from loader... If you would like them... */

/* Retrieves a setting */

extern int (*loader_is_playing) ();
extern void (*loader_play) ();
extern void (*loader_pause) ();
extern void (*loader_stop) ();
extern void (*loader_ff) ();
extern void (*loader_rw) ();
extern void (*loader_seek) (float position);
extern void (*loader_close) ();
extern int (*loader_activate) ();
extern int (*loader_deactivate) ();
extern void (*loader_exit) ();
extern void (*loader_set_setting) (gchar * sett, gchar * key);
extern char *(*loader_get_setting) (char *key);
extern void (*loader_activate_settings) ();
extern char *(*loader_get_error) ();
extern int (*loader_is_atend) ();
extern int (*loader_shutdown_ui) ();

/* Mandatory Funcions */
gchar **player_get_fnmasks ();

/* This function returns an array of fnmasks for use with fnmatch to signify
 * naming conventions for files the plugins can open */

guint32 player_open_plugin ();

/* Opens up plugin not for purpose of playing anything, but for purpose of 
 * information querying and configuration.  At this point, the settings
 * related functions and fnmask function should be working and do what you would
 * expect. */

guint32 player_open (char *file);

/* initializes player and attempts to load given location
 * should return 0 on fail, the ORed set of available features 
 * otherwise */

void player_close ();

/* Cleans up, plugin is being unloaded... */

/* Optional functions - Only need be defined if you intend to use them */
gchar *player_get_open_mask ();

/* returns a string of masks that the plugin can handle, separate 
   multiple masks with '\n' */

void player_play ();

/* write this function if CAN_PLAY is defined */

void player_pause ();

/* write this function if CAN_PAUSE is defined */

void player_ff ();

/* write this function if CAN_FF is defined */

void player_rw ();

/* write if CAN_RW is defined */

/* Following two is needed if GIVES_TIME is in featureset */
int player_get_time();
int player_get_max_time();

void player_next ();

void player_prev ();

void player_stop ();

void player_seek (float position);

float player_get_position ();

float player_get_max_position ();

void player_set_volume (float volume);

float player_get_volume ();

float player_get_max_volume ();

void player_loop ();

void player_double (int val);

void player_fullscreen ();

int player_get_height ();

int player_get_width ();

int player_get_frame ();

float player_get_fps ();

void player_activate_settings ();
gchar **player_get_settings ();
#endif
