#include "smpeg-player.h"
int tcp_open (char *address, int port);
int http_open (char *arg)
{
   char *host;
   int port;
   char *request;
   int tcp_sock;
   char http_request[1024];
   char c;

   /*
      Check for URL syntax 
    */
   if (strncmp (arg, "http://", strlen ("http://")))
      return (0);

   /*
      Parse URL 
    */
   port = 80;
   host = arg + strlen ("http://");
   if ((request = strchr (host, '/')) == NULL)
      return (0);
   *request++ = 0;
   if (strchr (host, ':') != NULL) {    /* port is specified */
      port = atoi (strchr (host, ':') + 1);
      *strchr (host, ':') = 0;
   }

   /*
      Open a TCP socket 
    */
   if (!(tcp_sock = tcp_open (host, port))) {
      perror ("http_open");
      return (0);
   }

   /*
      Send HTTP GET request 
    */
   sprintf (http_request,
            "GET /%s HTTP/1.0\r\n"
            "User-Agent: Mozilla/2.0 (Win95; I)\r\n"
            "Pragma: no-cache\r\n"
            "Host: %s\r\n" "Accept: */*\r\n" "\r\n", request, host);
   send (tcp_sock, http_request, strlen (http_request), 0);

   /*
      Parse server reply 
    */
   do
      read (tcp_sock, &c, sizeof (char));
   while (c != ' ');
   read (tcp_sock, http_request, 4 * sizeof (char));
   http_request[4] = 0;
   if (strcmp (http_request, "200 ")) {
      fprintf (stderr, "http_open: ");
      do {
         read (tcp_sock, &c, sizeof (char));
         fprintf (stderr, "%c", c);
      }
      while (c != '\r');
      fprintf (stderr, "\n");
      return (0);
   }

   return (tcp_sock);
}
