#include <X11/Xlib.h>
#include "smpeg-player.h"
Uint32 process_events (Uint32 interval, void *crap);

guint32 player_open_plugin ()
{
   static player_data t;

   m = &t;
   t.file_opened = 0;
   return 0;
}

guint32 player_open (char *name)
{
   Display *the_disp;
   int the_screen;
   static player_data t;
   int fd;
   int useaud = 1;
   char buf[32];
   char *dispname = ":0.0";

   t.file_opened = 1;
   if (getenv ("DISPLAY"))
      dispname = getenv ("DISPLAY");
   the_disp = XOpenDisplay (dispname);
   the_screen = DefaultScreen (the_disp);
   t.screenwidth = DisplayWidth (the_disp, the_screen);
   t.screenheight = DisplayHeight (the_disp, the_screen);
   XCloseDisplay (the_disp);    // That seems anti-climatic doesn't it :)
   t.isvcd = 0;
   t.doing_settings = 0;
	t.display_mutex = SDL_CreateMutex();
   //t.Xavail = SDL_CreateSemaphore (1);
   m = &t;
   t.volume = 100;
   t.loop = 0;
   t.do_double = 0;
   t.in_fullscreen = 0;
   set_vcd_device ();
   if (SDL_Init (SDL_INIT_AUDIO) < 0 || !SDL_AudioDriverName (buf, 1)) {
      useaud = 0;
   }
   if (SDL_InitSubSystem (SDL_INIT_TIMER) < 0) {
      m->error = g_strdup ("SDL Could not Initialize a timer!");
      return 0;
   }
   /*
      Check for Ip addr/port 
    */
   parse_url (name);
   if (!strcmp (name, "VCD"))
      name = m->vcd_device;
   if ((fd = raw_open (name)))
      m->mpeg = SMPEG_new_descr (fd, &(m->mpeg_info), useaud);
   else if ((fd = http_open (name)))
      m->mpeg = SMPEG_new_descr (fd, &(m->mpeg_info), useaud);
   else if ((fd = ftp_open (name)))
      m->mpeg = SMPEG_new_descr (fd, &(m->mpeg_info), useaud);
   else
#ifdef VCD_SUPPORT
   if ((fd = vcd_open (name))) {
      m->mpeg = SMPEG_new_descr (fd, &(m->mpeg_info), useaud);
      m->isvcd = 1;
      strcpy (name, "Video CD");
   } else
#endif
   {
      /*
         Assume it to be a file and try to open it 
       */
      m->mpeg = SMPEG_new (name, &(m->mpeg_info), useaud);
		SMPEG_enableaudio(m->mpeg,useaud);
   }
   if (SMPEG_error (m->mpeg)) {
      m->error = strdup (SMPEG_error (m->mpeg));
      return 0;
   }
   if (m->mpeg_info.has_video) {
      m->width = m->mpeg_info.width;
      m->timer_id = SDL_AddTimer (200, process_events, NULL);
      if (!m->timer_id)
         fprintf (stderr, "Timer error: %s", SDL_GetError ());
      m->height = m->mpeg_info.height;
      if (SDL_InitSubSystem (SDL_INIT_VIDEO) < 0) {
         m->error = strdup (SDL_GetError ());
         return 0;
      }
      SDL_WM_SetCaption (name, 0);
      SDL_ShowCursor (0);
   }
   m->video_flags = SDL_HWSURFACE | SDL_RESIZABLE;
   loader_activate_settings ();
   signal (SIGINT, SIG_DFL);
   return CAN_PLAY | CAN_PAUSE | CAN_STOP | CAN_LOOP | CAN_RW |
      GIVES_POSITION | GIVES_SETTINGS | GIVES_TIME |
		(useaud ? CAN_VOLUME : 0) |
      (m->mpeg_info.has_video ? CAN_DOUBLE : 0) |
      (m->mpeg_info.has_video ? GIVES_FRAME : 0) |
      (m->mpeg_info.has_video ? GIVES_FPS : 0) |
      (m->mpeg_info.has_video ? GIVES_RES : 0) |
      (m->mpeg_info.has_video ? CAN_FF : 0) |
      CAN_SEEK | (m->mpeg_info.has_video ? CAN_FULLSCREEN : 0);
}
