#include "smpeg-player.h"

void setup_screen ()
        /*
         * Sets up video screen, requires that m->video_flags set correctly
         * first 
         */
{
   static int gl_initted = 0;

   if (!m->mpeg_info.has_video) // Do not bother with video stuff w/ audio
      return;
   m->isplaying = (SMPEG_status (m->mpeg) == SMPEG_PLAYING);
   //if (m->isplaying) Hopefully no longer needed if the mutex code works ok
   //   loader_pause ();
	SDL_mutexP(m->display_mutex);
   //SDL_SemWait (m->Xavail);     // Wait for exclusive rights to video Window
#ifdef USE_GL
   if (m->video_flags & SDL_OPENGL) {
      SMPEG_scale (m->mpeg, 1);
      m->screen = SDL_SetVideoMode (m->width, m->height, 0, m->video_flags);
      m->surface = SDL_AllocSurface (SDL_SWSURFACE,
                                     m->mpeg_info.width,
                                     m->mpeg_info.height,
                                     32,
                                     0x000000FF,
                                     0x0000FF00, 0x00FF0000, 0xFF000000);
      gl_screen_init (m->mpeg_info.width, m->mpeg_info.height);
      gl_screen_resize (m->screen->w, m->screen->h);
      SMPEG_setdisplay (m->mpeg, m->surface, m->display_mutex, update);
      gl_initted = 1;
   } else {
      if (gl_initted) {
         gl_initted = 0;
         gl_screen_close ();
      }
#else
   {
#endif
      m->screen = SDL_SetVideoMode (m->width, m->height, 0, m->video_flags);
#ifdef USE_GL
		if (m->video_flags & SDL_OPENGL) 
      	SMPEG_setdisplay (m->mpeg, m->screen, m->display_mutex, update);
		else 
#endif
		SMPEG_setdisplay (m->mpeg,m->screen,m->display_mutex,NULL);
      SMPEG_scaleXY (m->mpeg, m->width, m->height);
   }
   //if (m->isplaying) // Hopefully not needed if mutex works right
   //   loader_play ();
   m->isplaying = 0;
	SDL_mutexV(m->display_mutex);
   //SDL_SemPost (m->Xavail);
}
