
/* SMPEG based plugin for Xtheater

   Copyright (C) 2000 Jarrod Johnson

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

   Author may be contacted at jbjohns4@eos.ncsu.edu
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <player.h>
#include <signal.h>
#include <smpeg.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <sys/time.h>
#define NET_SUPPORT             /* General network support */
#define RAW_SUPPORT             /* Raw data transport support */
#define HTTP_SUPPORT            /* HTTP support */
#define FTP_SUPPORT             /* FTP support */
#ifdef linux
#define VCD_SUPPORT             /* Video CD support */
#endif
#include <netinet/in.h>
#include <netdb.h>
#include <sys/socket.h>
#include <arpa/inet.h>

typedef struct {
   SMPEG *mpeg;
   SMPEG_Info mpeg_info;
   SDL_Surface *screen;
	SDL_mutex* display_mutex;
   //SDL_sem *Xavail; //Now using a semaphore as it can be shared with libsmpeg
	//itself, some functions on semaphores are more convenient, but no longer
	//having to pause playback to do stuff is nice..
   int width, height;
   int isvcd;
   int isplaying;
   int in_fullscreen;
   SDL_TimerID timer_id;
   int doing_settings;
   int screenwidth;             //These variables store the current resolution
   int screenheight;
   int file_opened;
#ifdef USE_GL
   SDL_Surface *surface;
   int gl_fullscreen;
   int gl_all;
#endif
   const SDL_VideoInfo *video_info;
   Uint32 video_flags;
   int volume;
   int loop;
   int do_double;
   int paused;
	float seek_value;

   char *error;
   char *vcd_device;
} player_data;

/* pointer to the location that all functions in smpeg plugin can access */
player_data *m;

void update (SDL_Surface * screen, Sint32 x, Sint32 y, Uint32 w, Uint32 h);

void setup_screen ();
void parse_url (char *name);
int tcp_open (char *address, int port);
int raw_open (char *arg);
int http_open (char *arg);
int vcd_open (const char *arg);
void player_activate_settings ();
int ftp_open (char *arg);
void player_set_vcd_device ();
