#include "smpeg-player.h"
#ifdef USE_GL
#include <GL/gl.h>
#include <GL/glu.h>
#endif

Uint32 process_events (Uint32 stupid, void *junk);

#ifdef USE_GL
void update (SDL_Surface * screen, Sint32 x, Sint32 y, Uint32 w, Uint32 h)
{

   if (m->video_flags & SDL_OPENGL) {
      GLenum error;

      if (m->doing_settings)
         return;

        /**********************************************************************
		 * If we cannot get the exclusive rights to the display right now     *
   	 * Then drop the frame, this keeps the video more in sync.            *
   	 * Besides, what could be blocking the semaphore could be a           *
   	 * multiplexed operation, not a separate thread, and in that case,    *
   	 * suspending the thread would cause deadlock                         *
		 **********************************************************************/
		if (SDL_mutexP(m->display_mutex)==-1) {
			fprintf(stderr,"Mutex lock failed in drawing function!");
			return;
		}
		/*
      if (SDL_SemTryWait (m->Xavail))
         return;
			*/

      gl_screen_draw ((GLubyte *) m->surface->pixels);
      error = glGetError ();
      if (error != GL_NO_ERROR) {
			if (SDL_mutexV(m->display_mutex)==-1) {
				fprintf(stderr,"CRTICAL, unlock mutex faild in draw function!");
				return;
			}
         //SDL_SemPost (m->Xavail);
         return;
      }
      SDL_GL_SwapBuffers ();
		if (SDL_mutexV(m->display_mutex)==-1) {
			fprintf(stderr,"CRTICAL, unlock mutex faild in draw function!");
			return;
		}
      //SDL_SemPost (m->Xavail);
   }
   //This function need not do anything if GL is not being used.
   return;
}
#endif

/* Check for pending requests by events committed to playback
 * screen */
Uint32 process_events (Uint32 stupid, void *junk)
{
   SDL_Event event;

   if (m->doing_settings)
      return 1;
	if (SDL_mutexP(m->display_mutex)==-1) {
		fprintf(stderr,"Unable to lock mutex in process_events function");
		return 42;
	}
   //SDL_SemWait (m->Xavail);     // Wait for exclusive Video Window access 
   if (SDL_PollEvent (&event)) {
		if (SDL_mutexV(m->display_mutex)==-1) {
			fprintf(stderr,"CRITICAL: could not unlock mutex in process_events");
			return 42;
		}
      //SDL_SemPost (m->Xavail);  // The Poll is over, relinquish the semaphore
		if (player_is_atend())
				player_stop();
      switch (event.type) {
         case SDL_KEYDOWN:
            switch (event.key.keysym.sym) {
					case SDLK_LEFT:
						player_rw();
						break;
					case SDLK_RIGHT:
						player_ff();
						break;
					case SDLK_s:
						player_stop();
						break;
               case SDLK_PAUSE:
               case SDLK_p:
                  player_pause ();
                  break;
					case SDLK_PAGEDOWN:
						SMPEG_seek(m->mpeg,0);
						break;
					case SDLK_ESCAPE:
						if (m->in_fullscreen) 
							player_fullscreen();
						else
							loader_close();
						break;
               case SDLK_f:
                  player_fullscreen ();
                  break;
               case SDLK_RETURN:
                  if (event.key.keysym.mod & KMOD_ALT)
                     player_fullscreen ();
                  break;
            }
            break;
         case SDL_VIDEORESIZE:
            if (!m->in_fullscreen) {
               m->width = event.resize.w;
               m->height = event.resize.h;
               setup_screen ();
            }
            break;
         case SDL_MOUSEBUTTONDOWN:
            if (m->in_fullscreen)
					player_fullscreen ();
				//else 
					//loader_activate();
            break;
         case SDL_QUIT:
            if (m->in_fullscreen)
               player_fullscreen ();
            else
               loader_close ();
            break;
      }
   } else
		if (SDL_mutexV(m->display_mutex)==-1) {
			fprintf(stderr,"CRITICAL: mutex would not unlock in process_events");
		}
   return 1;
}
