
/* This file contains routines related to extracting mpeg data from a VCD
 * This code is almost entirely copied from "plaympeg.c" from the smpeg-0.4.1
 * distribution, but is in major need of modification */
#include "smpeg-player.h"
#ifdef VCD_SUPPORT
#include <fcntl.h>
#include <sys/stat.h>
#include <linux/cdrom.h>
#include <sys/ioctl.h>

int fillThread;
int fd;
int pipe_fd[2];
int lba;
int startlba;
int endlba;

int vcd_get_position ()
{
   return 100 * (lba - startlba) / endlba;
}

void vcd_seek (int pos)
{
   lba = pos * endlba / 100 + startlba;
}

int vcd_read (int fd, int lba, unsigned char *buf)
{
   struct cdrom_msf *msf;

   msf = (struct cdrom_msf *) buf;
   msf->cdmsf_min0 = (lba + CD_MSF_OFFSET) / CD_FRAMES / CD_SECS;
   msf->cdmsf_sec0 = (lba + CD_MSF_OFFSET) / CD_FRAMES % CD_SECS;
   msf->cdmsf_frame0 = (lba + CD_MSF_OFFSET) % CD_FRAMES;
   return (ioctl (fd, CDROMREADMODE2, buf));
}

void fillPipe ()
{
   fd_set fdset;
   unsigned char *buffer;

   buffer = (unsigned char *) malloc (CD_FRAMESIZE_RAW0);

   for (lba = startlba; lba <= endlba + 10; lba++) {
      vcd_read (fd, lba, buffer);
      FD_ZERO (&fdset);
      FD_SET (pipe_fd[1], &fdset);
      if (select (pipe_fd[1] + 1, NULL, &fdset, NULL, NULL) <= 0)
         break;
      if (write (pipe_fd[1], buffer, CD_FRAMESIZE_RAW0) < 0)
         break;
   }
   free (buffer);
}

int vcd_open (const char *arg)
{
   struct cdrom_tocentry toc;
   struct cdrom_tocentry tocnexttrack;
   struct cdrom_tochdr tochdr;
   struct stat buf;
   char *pip;
   int track;

   /*
      Track defaults to 02, unless requested otherwise 
    */
   track = 02;
   pip = strrchr (arg, ':');
   if (pip) {
      *pip = '\0';
      track = atoi (pip + 1) + 1;
   }

   /*
      See if the CD-ROM device file exists 
    */
   if ((stat (arg, &buf) < 0) || !S_ISBLK (buf.st_mode)) {
      if (pip) {
         *pip = ':';
      }
      return (0);
   }

   fd = open (arg, O_RDONLY, 0);
   if (fd < 0) {
      if (pip) {
         *pip = ':';
      }
      return (0);
   }

   toc.cdte_track = track;
   toc.cdte_format = CDROM_LBA;
   if (ioctl (fd, CDROMREADTOCENTRY, &toc) < 0)
      return (0);
   startlba = toc.cdte_addr.lba;

   if (tochdr.cdth_trk1 == track)
      tocnexttrack.cdte_track = CDROM_LEADOUT;
   else
      tocnexttrack.cdte_track = track + 1;
   tocnexttrack.cdte_format = CDROM_LBA;

   ioctl (fd, CDROMREADTOCENTRY, &tocnexttrack);
   endlba = tocnexttrack.cdte_addr.lba - 10;

   if (pipe (pipe_fd) < 0)
      return (0);

   fillThread = SDL_CreateThread ((int (*)(void *)) fillPipe, NULL);

   return pipe_fd[0];
}
#endif
