#include <SDL_thread.h>
#include "wm_player.h"
#include <avifile/renderer.h>
wm_data *n;

// This function is provided to allow plugin to be opened without a 
// file, for configuration purposes or whatever else may be useful..
guint32
player_open_plugin ()
		  //
{
   static wm_data w;

   w.file_opened = false;
   n = &w;

   return 0;
}

guint32 player_open(char *name)
{
   static wm_data w;

   w.in_fullscreen = false;
   w.file_opened = true;
   n = &w;
   w.is_playing = 0;
   parse_url (name);
   w.name = strdup(name);
   pthread_mutex_init (&n->mutex, 0);
   char *disp_name = ":0.0";
   static Display *the_disp;

   if (getenv ("DISPLAY"))
      disp_name = getenv ("DISPLAY");
   the_disp = XOpenDisplay (disp_name);
   if (!the_disp) {
      fprintf (stderr, "messed up");
   }
   n->player = CreateAviPlayer2(&(n->pw), the_disp, name, NULL);
   n->height = n->player->GetHeight ();
   n->width = n->player->GetWidth ();
   player_activate_settings();
   n->player->Set(IAviPlayer::AUTOREPEAT,false,0);
   n->player->Start ();
   n->player->Play ();
   n->player->Resize (n->width, n->height);
   return CAN_PLAY | CAN_RW | CAN_PAUSE | CAN_STOP | CAN_SEEK |
      GIVES_POSITION | GIVES_RES | CAN_FULLSCREEN | GIVES_FPS |
      GIVES_SETTINGS | CAN_DOUBLE | CAN_VOLUME| CAN_SUB | GIVES_TIME;
}
