#ifndef _WM_PLAYER_H
#define _WM_PLAYER_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

extern "C" {
#include "../player.h"
};

#include "WMWidget.h"
#undef USE_GL
#include <stdint.h>
#include <SDL.h>
#include <pthread.h>
#include <avifile.h>
#include <aviplay.h>

typedef struct {
   WMWidget pw;
   IAviPlayer2 *player;
   int is_playing;
   SDL_Surface *screen;
   const SDL_VideoInfo *vid;
   Uint32 flags;
   int depth;
   size_t framesize;
   int width, height;
   char *error;
   bool in_fullscreen;
   bool fullscreen_scale;
   float fps;
   bool file_opened;
   pthread_mutex_t mutex;
   SDL_sem *Xavail;
   char* name;
} wm_data;

extern wm_data *n;
extern "C" {
   int player_is_playing ();
   void player_pause ();
   void player_play ();
   void player_activate_settings ();
};
void parse_url (char *name);
void setup_screen ();
void draw (const CImage * data, void *junk);
#endif
