
/* GTK UI code for Xtheater - Drag And Drop code

   Copyright (C) 2000 Jarrod Johnson

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

   Author may be contacted at jbjohns4@eos.ncsu.edu
*/
#include <string.h>
#include "gtk-ui.h"

/* Functions & Structures to handle drag and drop operatons   */

void
ui_drop_received (GtkWidget * widget, GdkDragContext * context, gint x,
                  gint y, GtkSelectionData * selection_data, guint info,
                  guint time, ui_data * m)
{
   if (selection_data->data) {
      ui_close (0, m);
      strncpy (m->name, (gchar *) selection_data->data, PATH_MAX + 9);
      if (m->name[strlen (m->name) - 1] == '\n')
         m->name[strlen (m->name) - 1] = 0;
      if (m->name[strlen (m->name) - 1] == '\r')
         m->name[strlen (m->name) - 1] = 0;
      if (m->name[strlen (m->name) - 1] == ' ')
         m->name[strlen (m->name) - 1] = 0;
      ui_open (m);
   }
}
