
/* GTK UI code for Xtheater - Definitions for all of GTK ui

   Copyright (C) 2000 Jarrod Johnson

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

   Author may be contacted at jbjohns4@eos.ncsu.edu
*/
#ifndef _GTK_UI_H
#define _GTK_UI_H
#include <gtk/gtk.h>
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "../ui.h"
#include "screensaver.h"
#include <gdk/gdkx.h>
#include "../plugin_defs.h"

/* Data type to hold widgets and data, ugly, but needed because GTK is crap */
typedef struct {
   /*
      Persistant data 
    */
   char name[PATH_MAX + 15];
   float last_volume;
   int user_seeking;
   int sighand;
   guint32 features;
   int updating;
   int play_expected;
   int looping;
   int ui_height;
   int ui_width;

   /*
      Text Widget 
    */
   GtkWidget *text;
   /*
      Containers and handles 
    */
   GtkWidget *dialog;
   GtkWidget *window;
   GtkWidget *main_column;
   GtkWidget *menu_handle;
   /*
      REMOVE GtkWidget* info_handle; 
    */
   GtkWidget *info_row;
   /*
      REMOVE GtkWidget* seek_handle;
      GtkWidget* volume_handle; 
    */
   /*
      GtkWidget* button_handle;
    */
   GtkWidget *button_row;
   GtkWidget *toggle_row;

   /*
      Menu related widgets 
    */
   GtkWidget *menu_bar;
   GtkWidget *media_menu_top;
   GtkWidget *option_menu_top;
   GtkWidget *info_menu_top;
   GtkWidget *media_menu;
   GtkWidget *media_open;
   GtkWidget *media_open_vcd;
   GtkWidget *media_open_url;
   GtkWidget *media_close;
   GtkWidget *media_quit;
   GtkWidget *option_menu;
   GtkWidget *option_ui;
   GtkWidget *option_plugin;
   GtkWidget *option_assoc;
   GtkWidget *option_save;
   GtkWidget *info_menu;
   GtkWidget *info_about;

   /*
      File selection dialog 
    */
   GtkWidget *file_sel;

   /*
      Stuff for the range adjustments. 
    */
   GtkWidget *seek_scale;
   GtkObject *seek_position;
   GtkWidget *volume_scale;
   GtkObject *volume_position;

   /*
      Pretty buttons 
    */
   GtkWidget *play_button;
   GtkWidget *pause_button;
   GtkWidget *stop_button;
   GtkWidget *ff_button;
   GtkWidget *rw_button;
   GtkWidget *prev_button;
   GtkWidget *next_button;
   GtkWidget *open_button;

   /*
      Toggle buttons 
    */
   GtkWidget *loop_toggle;
   GtkWidget *mute_toggle;
   GtkWidget *double_toggle;
   GtkWidget *full_toggle;

   /*
      Text Labels 
    */
   GtkWidget *name_label;
   GtkWidget *seek_label;
   GtkWidget *res_label;
   GtkWidget *fps_label;
   GtkWidget *frame_label;
   GtkWidget *volume_label;
} ui_data;

ui_data *ui;                    //Global pointer to provide global plugin access to this structure

/* Functions used in the GTK UI */

/* Defined in menu.c */
void ui_menu_create (ui_data * m);

/* imghandler.c */
void ui_button_pixmap (ui_data * m, GtkWidget * button, gchar ** the_pixmap);
void ui_do_icon (ui_data * m);

void ui_reconfig (ui_data * m);
void ui_widget_set_visible (GtkWidget * w, guint32);
void ui_create_widgets (ui_data * m);

/* defined in layout.c */
void ui_pack_widgets (ui_data * m);

/* defined in filedlg.c */
void file_select (GtkWidget * w, ui_data * m);
void file_ok (GtkWidget * w, ui_data * m);
void file_cancel (GtkWidget * w, ui_data * m);

/* defined in open.c */
void open_vcd (GtkWidget * w, ui_data * m);
void open_url (GtkWidget * w, ui_data * m);
int ui_open (ui_data * m);

/* defined in sigconnect.c */
void ui_connect_signals (ui_data * m);

void ui_pause (GtkWidget * w, ui_data * m);
void ui_play (GtkWidget * w, ui_data * m);
void ui_stop (GtkWidget * w, ui_data * m);
void ui_loop (GtkWidget * w, ui_data * m);
void ui_mute (GtkWidget * w, ui_data * m);
void ui_double (GtkWidget * w);
void ui_fullscreen (GtkWidget * w);
void ui_rw (GtkWidget * w);
void ui_seek (GtkObject * w, ui_data * m);
void ui_ff (GtkWidget * w);
void ui_exit (GtkWidget * w);
int ui_close (GtkWidget * w, ui_data * m);
gint ui_update_info (gpointer m);
void ui_set_volume (GtkWidget * w, ui_data * m);
void ui_options (GtkWidget * w, ui_data * m);
void ui_write_config (GtkWidget * j);
void ui_about (GtkObject * junk);
void
ui_drop_received (GtkWidget * widget, GdkDragContext * context, gint x, gint y,
                  GtkSelectionData * selection_data, guint info, guint time,
                  ui_data * m);
void ui_plugin_options (GtkWidget * w, ui_data * m);
void ui_stop_track (GtkObject * w, ui_data * m);
void ui_start_track (GtkObject * w, ui_data * m);
#endif
