
/* GTK UI code for Xtheater - Code to manage GTK ui layout

   Copyright (C) 2000 Jarrod Johnson

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

   Author may be contacted at jbjohns4@eos.ncsu.edu
*/
#include "gtk-ui.h"

/* Control layout of pretty much everything */
void ui_pack_widgets (ui_data * m)
{
   gtk_container_border_width (GTK_CONTAINER (m->main_column), 1);
   gtk_container_add (GTK_CONTAINER (m->window), m->main_column);

   gtk_box_pack_start (GTK_BOX (m->main_column), m->menu_handle, FALSE, TRUE,
                       0);

   gtk_box_pack_start (GTK_BOX (m->main_column), m->seek_label, TRUE, TRUE, 0);
   gtk_box_pack_start (GTK_BOX (m->main_column), m->seek_scale, TRUE, TRUE, 0);
   gtk_box_pack_start (GTK_BOX (m->main_column), m->name_label, TRUE, TRUE, 0);
   gtk_box_pack_start (GTK_BOX (m->main_column), m->info_row, TRUE, TRUE, 0);
   gtk_box_pack_start (GTK_BOX (m->info_row), m->res_label, TRUE, TRUE, 0);
   gtk_box_pack_start (GTK_BOX (m->info_row), m->frame_label, TRUE, TRUE, 0);
   gtk_box_pack_start (GTK_BOX (m->info_row), m->fps_label, TRUE, TRUE, 0);

   gtk_box_pack_start (GTK_BOX (m->main_column), m->button_row, TRUE, TRUE, 0);
   gtk_box_pack_start (GTK_BOX (m->main_column), m->toggle_row, TRUE, TRUE, 0);
   gtk_box_pack_start (GTK_BOX (m->main_column), m->volume_label, TRUE, TRUE,
                       0);
   gtk_box_pack_start (GTK_BOX (m->main_column), m->volume_scale, TRUE, TRUE,
                       0);
   gtk_box_pack_start (GTK_BOX (m->button_row), m->prev_button, TRUE, TRUE, 0);
   gtk_box_pack_start (GTK_BOX (m->button_row), m->rw_button, TRUE, TRUE, 0);
   gtk_box_pack_start (GTK_BOX (m->button_row), m->play_button, TRUE, TRUE, 0);
   gtk_box_pack_start (GTK_BOX (m->button_row), m->pause_button, TRUE, TRUE, 0);
   gtk_box_pack_start (GTK_BOX (m->button_row), m->ff_button, TRUE, TRUE, 0);
   gtk_box_pack_start (GTK_BOX (m->button_row), m->next_button, TRUE, TRUE, 0);
   gtk_box_pack_start (GTK_BOX (m->button_row), m->stop_button, TRUE, TRUE, 5);
   gtk_box_pack_start (GTK_BOX (m->button_row), m->open_button, TRUE, TRUE, 0);

   gtk_box_pack_start (GTK_BOX (m->toggle_row), m->loop_toggle, TRUE, TRUE, 0);
   gtk_box_pack_start (GTK_BOX (m->toggle_row), m->mute_toggle, TRUE, TRUE, 0);
   gtk_box_pack_start (GTK_BOX (m->toggle_row), m->double_toggle, TRUE, TRUE,
                       0);
   gtk_box_pack_start (GTK_BOX (m->toggle_row), m->full_toggle, TRUE, TRUE, 0);

   gtk_widget_show_all (m->window);
}
