
/* GTK UI code for Xtheater - assign loader function poinbters

   Copyright (C) 2000 Jarrod Johnson

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

   Author may be contacted at jbjohns4@eos.ncsu.edu
*/

/* Code to assign function pointers to loaders functions */
#include "../ui.h"
typedef struct {
   void (*play) ();
   void (*pause) ();
   void (*stop) ();
   void (*ff) ();
   void (*rw) ();
   void (*prev) ();
   void (*next) ();
   void (*loop) ();
   void (*setvol) (float vol);
   float (*getvol) ();
   float (*getmaxvol) ();
   void (*seek) (float position);
   int (*gettime) ();
   int (*getmaxtime) ();
   float (*getpos) ();
   float (*getmaxpos) ();
   void (*doubles) (int val);
   void (*fullscreen) ();
   int (*height) ();
   int (*width) ();
   int (*frame) ();
   float (*fps) ();
     guint32 (*open) (char *name);
   void (*close) ();
   void (*lexit) ();
   char *(*getset) (char *ky);
   void (*setset) (char *set, char *val);
   void (*wrtcfg) ();
   void (*setass) (char *tp, char *plug);
   char **(*plggetstg) ();
   void (*actset) ();
   char *(*geterr) ();
   int (*isplay) ();
   int (*atend) ();
} loader_func_struct;

void assign_funcs (loader_func_struct f)
{
   loader_is_playing = f.isplay;
   loader_is_atend = f.atend;
   loader_play = f.play;
   loader_pause = f.pause;
   loader_stop = f.stop;
   loader_ff = f.ff;
   loader_rw = f.rw;
   loader_prev = f.prev;
   loader_next = f.next;
   loader_loop = f.loop;
   loader_set_volume = f.setvol;
   loader_get_volume = f.getvol;
   loader_get_max_volume = f.getmaxvol;
   loader_seek = f.seek;
   loader_get_time = f.gettime;
   loader_get_max_time = f.getmaxtime;
   loader_get_position = f.getpos;
   loader_get_max_position = f.getmaxpos;
   loader_double = f.doubles;
   loader_fullscreen = f.fullscreen;
   loader_get_height = f.height;
   loader_get_width = f.width;
   loader_get_frame = f.frame;
   loader_get_fps = f.fps;
   loader_open = f.open;
   loader_close = f.close;
   loader_exit = f.lexit;
   loader_get_setting = f.getset;
   loader_set_setting = f.setset;
   loader_write_config = f.wrtcfg;
   loader_set_assoc = f.setass;
   loader_get_plugin_settings = f.plggetstg;
   loader_activate_settings = f.actset;
   loader_get_error = f.geterr;
}
