
/* GTK UI code for Xtheater - Menu setup code

   Copyright (C) 2000 Jarrod Johnson

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

   Author may be contacted at jbjohns4@eos.ncsu.edu
*/
#include "gtk-ui.h"

/* Function to create menu, handle and all, pre-shown. */
void ui_menu_create (ui_data * m)
{
   m->menu_handle = gtk_handle_box_new ();
   m->menu_bar = gtk_menu_bar_new ();
   m->media_menu = gtk_menu_new ();
   m->option_menu = gtk_menu_new ();
   m->info_menu = gtk_menu_new ();
   m->media_menu_top = gtk_menu_item_new_with_label ("Media");
   m->option_menu_top = gtk_menu_item_new_with_label ("Options");
   m->info_menu_top = gtk_menu_item_new_with_label ("Info");

   m->media_open = gtk_menu_item_new_with_label ("Open Local File");
   m->media_open_vcd = gtk_menu_item_new_with_label ("Open VCD");
   m->media_open_url = gtk_menu_item_new_with_label ("Open URL");
   m->media_close = gtk_menu_item_new_with_label ("Close current media");
   m->option_ui = gtk_menu_item_new_with_label ("UI options");
   m->option_plugin = gtk_menu_item_new_with_label ("Plugin options");
   //m->option_assoc = gtk_menu_item_new_with_label("File Associations");
   m->option_save = gtk_menu_item_new_with_label ("Save Options");
   m->media_quit = gtk_menu_item_new_with_label ("Quit");
   m->info_about = gtk_menu_item_new_with_label ("About");

   gtk_menu_append (GTK_MENU (m->media_menu), m->media_open);
   gtk_menu_append (GTK_MENU (m->media_menu), m->media_open_vcd);
   gtk_menu_append (GTK_MENU (m->media_menu), m->media_open_url);
   gtk_menu_append (GTK_MENU (m->media_menu), m->media_close);
   gtk_menu_append (GTK_MENU (m->media_menu), m->media_quit);
   gtk_menu_append (GTK_MENU (m->option_menu), m->option_ui);
   gtk_menu_append (GTK_MENU (m->option_menu), m->option_plugin);

   //gtk_menu_append(GTK_MENU(m->option_menu), m->option_assoc);
   gtk_menu_append (GTK_MENU (m->option_menu), m->option_save);
   gtk_menu_append (GTK_MENU (m->info_menu), m->info_about);
   gtk_menu_item_set_submenu (GTK_MENU_ITEM (m->media_menu_top), m->media_menu);
   gtk_menu_item_set_submenu (GTK_MENU_ITEM (m->option_menu_top),
                              m->option_menu);
   gtk_menu_item_set_submenu (GTK_MENU_ITEM (m->info_menu_top), m->info_menu);
   gtk_menu_bar_append (GTK_MENU_BAR (m->menu_bar), m->media_menu_top);
   gtk_menu_bar_append (GTK_MENU_BAR (m->menu_bar), m->option_menu_top);
   gtk_menu_bar_append (GTK_MENU_BAR (m->menu_bar), m->info_menu_top);
   gtk_container_add (GTK_CONTAINER (m->menu_handle), m->menu_bar);
   gtk_widget_show_all (m->menu_handle);
}
